<?php

namespace App\Http\Controllers\CAT;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class CatController extends Controller
{

    public static function cat_config()
    {
        $response = [
            "como_te_enteraste" => true,
            "factura_cotizacion_nota_sencilla_interno" => "nota_sencilla"
        ];

        return $response;
    }

    public static function cat_periodo_pago()
    {
        $data_db = DB::table('cat_periodo_pago')
            ->select('*')
            ->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_sexo()
    {
        $data_db = DB::table('cat_sexo')->select('*')->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_tipo_usuario($aqui = false, $id_cat_tipo_usuario = false)
    {
        if ($id_cat_tipo_usuario === 1) {
            $data_db = DB::table('cat_tipo_usuario')
                ->where('activo', '=', 1)
                ->select('*')->get();
        } else {
            $data_db = DB::table('cat_tipo_usuario')
                ->where('id_cat_tipo_usuario', '!=', 1)
                ->where('activo', '=', 1)
                ->select('*')->get();
        }

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        if ($aqui) {
            return $data;
        } else {
            return $response;
        }
    }

    public static function cat_estado()
    {
        $data_db = DB::table('cat_estado')
            ->select('*')
            ->orderBy('estado')
            ->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_municipio($id_estado = null)
    {
        if (!isset($id_estado)) {
            $data_db = DB::table('cat_municipio')
                ->select('*')->orderBy('municipio')->get();
        } else {
            $data_db = DB::table('cat_municipio')
                ->where('id_cat_estado', '=', $id_estado)
                ->select('*')->orderBy('municipio')->get();
        }

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_tipo_sangre()
    {
        $data_db = DB::table('cat_tipo_sangre')
            ->select('cat_tipo_sangre.*')
            ->where('activo', '=', 1)
            ->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_instructor()
    {

        $data_db = DB::table('usuario')
            ->select('usuario.*',
                DB::raw('CONCAT(usuario.nombre, " ", usuario.apellido_paterno, " ", usuario.apellido_materno) AS nombre_completo'),
                'cat_tipo_usuario.tipo_usuario'
            )
            ->where('usuario.id_cat_tipo_usuario', '=', 3)
            ->where('usuario.activo', '=', 1)
            ->leftJoin('cat_tipo_usuario', 'cat_tipo_usuario.id_cat_tipo_usuario', '=', 'usuario.id_cat_tipo_usuario')
            ->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_modalidad()
    {
        $data_db = DB::table('cat_modalidad')
            ->where('activo', '=', 1)
            ->select('*')
            ->orderBy('modalidad')
            ->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_tipo_inscripcion()
    {
        $data_db = DB::table('cat_tipo_inscripcion')
            ->where('activo', '=', 1)
            ->select('*')
            ->orderBy('tipo_inscripcion')
            ->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_horario()
    {
        $data_db = DB::table('cat_horario')
            ->where('activo', '=', 1)
            ->select('*')
            ->orderBy('horario')
            ->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }

    public static function cat_nivel()
    {
        $data_db = DB::table('cat_nivel')
            ->where('activo', '=', 1)
            ->select('*')
            ->orderBy('nivel')
            ->get();

        if ($data_db == null) {
            $flag_request = true;
            $status = 400;
            $message = "No se encontraron datos.";
            $data = array();
        } else {
            $flag_request = true;
            $status = 200;
            $message = "Datos encontrados.";
            $data = $data_db;
        }

        $response = [
            "success" => $flag_request,
            "status" => $status,
            "message" => $message,
            "data" => $data
        ];

        return $response;
    }
}
