<?php

namespace App\Http\Controllers\EXPORT;

use App\Http\Controllers\Controller;
use App\Http\Dao\Implement\IDAOUsuario;
use App\Http\Dao\Implement\IDAOExpediente;


class ExportarExpedienteController extends Controller
{
    protected $IDAOUsuario = null;
    protected $IDAOExpediente = null;

    public function __construct(IDAOUsuario $IDAOUsuario, IDAOExpediente $IDAOExpediente)
    {
        $this->IDAOUsuario = $IDAOUsuario;
        $this->IDAOExpediente = $IDAOExpediente;
    }

    public function expedientexid($key = null)
    {

        ob_start();

        $Obj = (new UtilPDFController)->AuthToken($key, $Usr, $errors);

        if ($Obj['success']) {

            if ($Obj['access']) {

                $id_expediente = $Obj['request']['data']['id_expediente'];
                //$tipo = $Obj['request']['data']['tipo'] ?? "";
                $tipo = null;
                switch ($tipo) {
                    case 1:
                        $accion = "IMPRIMIR";
                        break;
                    case 2:
                        $accion = "VER";
                        break;
                    case 3:
                        $accion = "DESCARGAR";
                        break;
                    default:
                        $accion = "VER";
                }


                $this->IDAOExpediente->setIdExpediente($id_expediente);
                $expediente = $this->IDAOExpediente->show();
                //dd($expediente);
                if ($expediente) {

                    foreach ($expediente->listar_archivo_integracion_expediente as $key => $rowe) {
                        $expediente_datos[] = array(
                            'id_expediente' => $key + 1,
                            'archivo_integracion_expediente' => $rowe->archivo_integracion_expediente,
                            'tipo_doc' => $rowe->tipo_doc == "1" ? "Original":"Copia",
                            'validado' => $rowe->validado == "1" ? "Si":"No",
                            'entregado' => $rowe->validado == null && $rowe->tipo_doc == null ? "No":"Si",
                            'observaciones' => $rowe->descripcion ? $rowe->descripcion:"-",
                        );
                    }

                    $titulo = "Expediente | Acreditado";

                    $settings = array(
                        'MARCA_TEXTO' => array(
                            'LABEL' => $marca_texto ?? '',
                            'ANGLE' => $ANGLE ?? 0,
                            'X_INIT' => $X_INIT ?? 0,
                            'Y_INIT' => $Y_INIT ?? 0,
                            'COLOR' => "#7b7b7b",
                        ),
                        'FOLIO' => $expediente->id_expediente,
                        'FECHA_ALTA' => $this->FechaTexto($expediente->created_at),
                        'FECHA_ENTREGA' => "",
                        'ACREDITADO' => $expediente->nombre_completo,
                        'OBSERVACIONES' => $expediente->observaciones ?? "Sin observaciones.",
                        'EXPEDIENTE' => $expediente,

                        'CABECERA' => array(
                            'TITLE' => "OPERADORA PROCEA DEL CENTRO S.A. DE C.V. SOFOM, E.N.R.",
                            'SHOW_TITLE' => true,
                            'SHOW_DATOS' => true,
                            'SHOW_HIDDEN' => "SHOW,SHOW,SHOW,SHOW,SHOW,SHOW",
                            'DATOS' => array(
                                'RFC' => strtoupper($expediente->rfc),
                                'CURP' => strtoupper($expediente->curp),
                                'FECHA DE NACIMIENTO' => strtoupper($expediente->fecha_nacimiento),
                                'COMPROBANTE DE INGRESO' => strtoupper($expediente->comprobante_ingreso),
                                'QUIÉN ES QUIÉN' => strtoupper($expediente->quien_es_quien ? 'OK': 'No Apto'),
                                'IDENTIFICACIÓN' => strtoupper($expediente->identificacion),
                            )
                        ),

                        'DETALLE' => array(
                            'TITLE' => "PRODUCTOS",
                            'TAMANIO' => "15,40,25,25,25,62",
                            'ALINEACION' => "C,C,C,C,C",
                            'SHOW_HIDDEN' => "SHOW,SHOW,SHOW,SHOW,SHOW,SHOW",

                            'HTML_ETIQUETA' => array(
                                '0' => "N.P.",
                                '1' => "DOCUMENTO",
                                '2' => "TIPO",
                                '3' => "VALIDADO",
                                '4' => "ENTREGADO",
                                '5' => "OBSERVACIONES",
                            ),

                            'HTML_CAMPOS' => array(
                                '0' => array('NOMBRE' => 'id_expediente'),
                                '1' => array('NOMBRE' => 'archivo_integracion_expediente'),
                                '2' => array('NOMBRE' => 'tipo_doc'),
                                '3' => array('NOMBRE' => 'validado'),
                                '4' => array('NOMBRE' => 'entregado'),
                                '5' => array('NOMBRE' => 'observaciones'),
                            ),

                        )
                    );



                    UtilPDFController::GenerarFILE($settings, $expediente_datos, $titulo, "expediente-acreditado", "PDF", $accion, "CV", "", "", "", 0);

                } else {

                    dd(array(
                        'success' => false,
                        'status' => 400,
                        'message' => 'No se encontraron los datos de la venta',
                        "errors" => array()
                    ));

                }

            } else {

                dd($errors);

            }

        } else {

            dd($Obj);

        }

        ob_end_flush();

    }

}
