<?php

namespace App\Http\Controllers\EXPORT;

use App\Http\Controllers\Controller;
use App\Http\Dao\Implement\IDAOUsuario;
use App\Http\Dao\Implement\IDAOExpediente;
use Exception;
use Illuminate\Support\Facades\Storage;
use RecursiveDirectoryIterator;
use \RecursiveIteratorIterator;
use ZipArchive;


class ExportarNubeController extends Controller
{
    protected $IDAOUsuario = null;
    protected $IDAOExpediente = null;

    public function __construct(IDAOUsuario $IDAOUsuario, IDAOExpediente $IDAOExpediente)
    {
        $this->IDAOUsuario = $IDAOUsuario;
        $this->IDAOExpediente = $IDAOExpediente;
    }

    public function descarga($key = null)
    {

        ob_start();

        $Obj = (new UtilPDFController)->AuthToken($key, $Usr, $errors);
        if ($Obj['success']) {

            if ($Obj['access']) {
                if($Obj['request']['data']['archivo']) {
                    $archivo = "public/recibos/". $Obj['request']['data']['archivo'];
                    $ruta = explode('.', $archivo);

                    if ($ruta[count($ruta) - 1] === 'pdf' || $ruta[count($ruta) - 1] === 'xml') {
                        return Storage::disk('local')->download($archivo);
                    } else {
                        try {
                            $rootPath = storage_path("app/public/recibos/".$Obj['request']['data']['archivo'].'/');

                            $zip = new ZipArchive();
                            $zip->open($archivo . '.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);

                            $files = new RecursiveIteratorIterator(
                                new RecursiveDirectoryIterator($rootPath),
                                RecursiveIteratorIterator::LEAVES_ONLY
                            );

                            foreach ($files as $name => $file) {
                                if (!$file->isDir()) {
                                    $filePath = $file->getRealPath();
                                    $relativePath = substr($filePath, strlen($rootPath) + 1);
                                    $zip->addFile($filePath, $relativePath);
                                }
                            }
                            $rest = $zip->close();

                            $zip_file = $archivo. '.zip';

                            ob_end_clean();
                            ob_start();

                            return response()->download($zip_file);
                        } catch (Exception $e) {
                            $log = $this->ErrorTransaction($e, '');
                            return $log;
                        }
                    }
                }

            } else {

                dd($errors);

            }

        } else {

            dd($Obj);

        }

        ob_end_flush();

    }

}
