<?php

namespace App\Http\Controllers\EXPORT\LIBS;

/**
 * Pulgada – 2.54 cm
 * Punto – 1/72 pulgada
 * Punto – 0.35 mm – 0.03527 7777 (valor tomado en los calculos)
 *
 * Por defecto es mm
 * Ejemplo Tamaño Carta medidas w 21.59 | h 27.94.
 * 612 x 72 = 44064
 * 792 x 72 = 57024
 * 21.59 / 612 = 0.03527 7777
 * 27.94 / 792 = 0.03527 7777
 * 21.59 / 0.03527 7777 = 612.0000135
 * 27.94 / 0.03527 7777 = 792.0000175
 *
 * Tomando el valor en mm las medidas aumentan un poco, queda a criterio de cada uno
 *
 * 21.59 / 0.035 = 616.86
 * 27.94 / 0.035 = 798.29
 *
 * Media Carta
 * 10.79 / 0.03527 7777 = 311 – 310.9606368
 * 13.97 / 0.03527 7777 = 396
 *
 * $pdf->fwPt = 616.86;
 * $pdf->fhPt = 798.29;
 */
class GenerateORDENVENTA
{

    /*
     * GENERAR ORDEN D VENTA
     * */
    public static function GeneratePDF($dato, $como_te_enteraste, $tipo_requerimiento, &$DATOSEXCEL)
    {
        $HEX01 = $dato['INFO']['CONFIGURACION']['COLOR_PRIMARIO'];

        $HEX02 = $dato['INFO']['CONFIGURACION']['COLOR_SECUNDARIO'];

        if ($HEX02 == "" || $HEX01 == "") {
            $dato['INFO']['CONFIGURACION']['COLOR_PRIMARIO'] = '#E4100A';
            $dato['INFO']['CONFIGURACION']['COLOR_SECUNDARIO'] = '#25A79F';
        }

        $_CONFIGCELDA['TAMANIO_CELDA_DETALLE'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['TAMANIO_CELDA_DETALLE'];
        $_CONFIGCELDA['TAMANIO_CELDA_DETALLE_RESUMEN'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['TAMANIO_CELDA_DETALLE_RESUMEN'];
        $_CONFIGCELDA['ALINEACION_CELDA_DETELLE'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['ALINEACION_CELDA_DETELLE'];
        $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_HIDDEN_COLUMNA_DETALLE'];
        $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA_NODO'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_HIDDEN_COLUMNA_DETALLE_NODO'];

        $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA_CABECERA'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_HIDDEN_COLUMNA_CABECERA'];

        $_CONFIGCELDA['MARCA_DE_AGUA'] = $dato['INFO']['CONFIGURACION']['MARCA_DE_AGUA'];
        if ($dato['INFO']['CONFIGURACION']['POSICION_LOGO']) {
            $_CONFIGCELDA['POSICION_LOGO'] = $dato['INFO']['CONFIGURACION']['POSICION_LOGO'];
        } else {
            $_CONFIGCELDA['POSICION_LOGO'] = "RIGHT";
        }
        $_CONFIGCELDA['POSICION_CELDA_DETALLE'] = $dato['INFO']['CONFIGURACION']['POSICION_CELDA_DETALLE'];

        $_CONFIGCELDA['POSICION_CELDA_DETALLE_NODO'] = $dato['INFO']['CONFIGURACION']['POSICION_CELDA_DETALLE_NODO'];

        $_CONFIGCELDA['TEXTO_EXTRA'] = $dato['INFO']['CONFIGURACION']['TEXTO_EXTRA'];

        if ($dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_TITLE'] || $dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_DATOS']) {

            $TIPO_FORMS = "CABECERADTALLE";

            /*
             * FUNCIONALIDAD CABECERA
             * */

            $HTML_ETIQUETA_CABECERA = $dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['DATOS'];
            $CD_Print = "Vacio";

            foreach ($HTML_ETIQUETA_CABECERA as $key => $val) {
                if ($val != "" && $val != NULL) {
                    $CD_Print = "ConDatos";
                }
            }

            /*
             * FUNCIONALIDAD DETALLE
             * */

            $HTML_ETIQUETA_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_ETIQUETA'];
            $HTML_CAMPOS_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_CAMPOS'];

            $HTML_ETIQUETA_DETALLE_NODO = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_ETIQUETA_NODO'];
            $HTML_CAMPOS_NODO = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_CAMPOS_NODO'];

            $HTML_DATOS_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_DATOS'];

        } else {

            $TIPO_FORMS = "DETALLE";

            /*
             * FUNCIONALIDAD CABECERA
             * */

            $HTML_ETIQUETA_CABECERA = array();
            $CD_Print = "Vacio";

            /*
             * FUNCIONALIDAD DETALLE
             * */

            $HTML_ETIQUETA_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_ETIQUETA'];
            $HTML_CAMPOS_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_CAMPOS'];

            $HTML_ETIQUETA_DETALLE_NODO = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_ETIQUETA_NODO'];
            $HTML_CAMPOS_NODO = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_CAMPOS_NODO'];

            $HTML_DATOS_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_DATOS'];
        }


        switch ($dato['SETTINGS']['size']) {
            case 'CartaVertical':
                $pdf = new PDF('P', 'mm', 'Letter');
                $CANPUNTO = 150;
                break;
            case 'CartaHorizontal':
                $pdf = new PDF('L', 'mm', 'Letter');
                $CANPUNTO = 150;
                break;
            case 'OficioVertical':
                $pdf = new PDF('P', 'mm', 'legal');
                $CANPUNTO = 150;
                break;
            case 'OficioHorizontal':
                $pdf = new PDF('L', 'mm', 'legal');
                $CANPUNTO = 150;
                break;
        }

        $LINEAPUNTEADA = '';

        for ($PUN = 0; $PUN < $CANPUNTO; $PUN++) {
            $LINEAPUNTEADA .= " - ";
        }

        $LINEAPUNTEADA = trim($LINEAPUNTEADA);

        $pdf->setDATOS($dato);
        $pdf->setReferenceWatermark(1);
        $pdf->AliasNbPages();
        $pdf->AddPage();
        $pdf->SetAutoPageBreak(false, 20);

        $INFOFOOTER[0] = $pdf->DecodeText($dato['INFO']['EMPRESA_RAZON_SOCIAL']);
        $INFOFOOTER[1] = $pdf->DecodeText($dato['INFO']['EMPRESA_DIRECCION']) . " | " . $pdf->DecodeText($dato['INFO']['EMPRESA_TELEFONO']) . " | " . $pdf->DecodeText($dato['INFO']['EMPRESA_PAGINA_WEB']);


        // INICIO LOGO
        switch ($_CONFIGCELDA['POSICION_LOGO']) {
            case 'RIGHT':
                switch ($dato['SETTINGS']['size']) {
                    case 'CartaVertical':
                        $cw = 161.5;
                        break;
                    case 'CartaHorizontal':
                        $cw = 226;
                        break;
                    case 'OficioVertical':
                        $cw = 161.5;
                        break;
                    case 'OficioHorizontal':
                        $cw = 301.5;
                        break;
                }

                $ch = 12;

                $wi = 40;
                $hi = 25;
                break;
            case 'LEFT':
                $cw = 12;
                $ch = 12;

                $wi = 40;
                $hi = 25;
                break;
        }

        if ($dato['INFO']['EMPRESA_LOGO'] != "") {
            $rootlogo = env('DOC_IMAGE_TO_PDF') . $dato['INFO']['EMPRESA_LOGO'];
            if (file_exists($rootlogo)) {
                $pdf->Image($rootlogo, $cw, $ch, $wi, $hi);
            }
        }

        $CONTINUACION_Y1 = ($ch + $hi);
        // FIN LOGO


        // INICIO VARIABLES
        $x = 12;
        $y = 12;
        $texX = 90;
        $texY = 4;

        $pdf->SetXY($x, $y);
        // FIN VARIABLES

        // INICIO DATOS DERECHA
        switch ($_CONFIGCELDA['POSICION_LOGO']) {
            case 'RIGHT':
                $x = $x;
                break;
            case 'LEFT':
                $x = $x + 42;
                break;
        }

        if ($dato['INFO']['EMPRESA_NOMBRE_COMERCIAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negro', 10, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_NOMBRE_COMERCIAL']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_RAZON_SOCIAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negro', 9, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_RAZON_SOCIAL']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_SUCURSAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negroregular', 8, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_SUCURSAL']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_CLAVE']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negroregular', 8, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_CLAVE']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_RFC']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negroregular', 8, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_RFC']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_DIRECCION']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negroregular', 8, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_DIRECCION']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_TELEFONO'] && $dato['INFO']['EMPRESA_CORREO_ELECTRONICO']) {

            if ($dato['INFO']['EMPRESA_TELEFONO']) {
                $y = $pdf->GetY();
                $pdf->SetXY($x, $y);
                $pdf->printColor('negroregular', 8, '#ffffff');
                $pdf->MultiCell($texX, $texY, $pdf->DecodeText("Tel.: " . $dato['INFO']['EMPRESA_TELEFONO'] . "   Email: " . $dato['INFO']['EMPRESA_CORREO_ELECTRONICO']), 0, 'L', false);
            }

        } else {

            if ($dato['INFO']['EMPRESA_TELEFONO']) {
                $y = $pdf->GetY();
                $pdf->SetXY($x, $y);
                $pdf->printColor('negroregular', 8, '#ffffff');
                $pdf->MultiCell($texX, $texY, $pdf->DecodeText("Tel.: " . $dato['INFO']['EMPRESA_TELEFONO']), 0, 'L', false);
            }

            if ($dato['INFO']['EMPRESA_CORREO_ELECTRONICO']) {
                $y = $pdf->GetY();
                $pdf->SetXY($x, $y);
                $pdf->printColor('negroregular', 8, '#ffffff');
                $pdf->MultiCell($texX, $texY, $pdf->DecodeText("Email: " . $dato['INFO']['EMPRESA_CORREO_ELECTRONICO']), 0, 'L', false);
            }

        }

        $CONTINUACION_Y2 = $pdf->GetY();
        // FIN DATOS DERECHA

        // INICIO VARIABLES
        $x = 5;
        $y = 12;
        switch ($dato['SETTINGS']['size']) {
            case 'CartaVertical':
                $texX = 97.8;
                break;
            case 'CartaHorizontal':
                $texX = 155;
                break;
            case 'OficioVertical':
                $texX = 230;
                $texX = 97.8;
                break;
            case 'OficioHorizontal':
                $texX = 238;
                break;
        }
        $texY = 5;
        $pdf->SetXY($x, $y);
        // FIN VARIABLES

        // INICIO DATOS IZQUIERDA
        switch ($_CONFIGCELDA['POSICION_LOGO']) {
            case 'RIGHT':
                $x = $x;
                break;
            case 'LEFT':
                $x = $x + 42;
                break;
        }

        if ($dato['folio']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 97, $y);
            $pdf->printColor(null, 13, '#FFFFFF');
            $pdf->MultiCell($texX - 40, $texY, "Folio: " . utf8_decode($dato['folio']), 0, 'R', true);
        }

        $y = $pdf->GetY();
        $pdf->SetXY($x + 97, $y);
        $pdf->printColor('negro', 13, '#ffffff');
        $pdf->MultiCell($texX - 40, $texY, utf8_decode($dato['title']), 0, 'R', false);

        if ($dato['pedido']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 97, $y);
            $pdf->printColor(null, 13, '#FFFFFF', '#ff0000');
            $pdf->MultiCell($texX - 40, $texY, "# " . utf8_decode($dato['pedido']), 0, 'R', true);
        }

        if ($dato['fecha_alta']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 97, $y);
            $pdf->printColor('negroregular', 10, '#ffffff');
            $pdf->MultiCell($texX - 40, $texY, utf8_decode("Fecha alta: " . $dato['fecha_alta']), 0, 'R', true);
        }

        if ($dato['fecha_entrega']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 97, $y);
            $pdf->printColor('negroregular', 10, '#ffffff');
            $pdf->MultiCell($texX - 40, $texY, utf8_decode("Fecha entrega: " . $dato['fecha_entrega']), 0, 'R', true);
        }

        $y = $pdf->GetY();
        $pdf->SetXY($x + 97, $y);
        $pdf->printColor('', 8, '#FFFFFF', '#808080');
        $pdf->MultiCell($texX - 40, $texY, utf8_decode("Fecha de exportación: " . date("d-m-Y")), 0, 'R', false);

        if ($dato['usuario_exporto']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 97, $y);
            $pdf->printColor('', 8, '#FFFFFF', '#808080');
            $pdf->MultiCell($texX - 40, $texY, utf8_decode("Usuario: " . $dato['usuario_exporto']), 0, 'R', false);
        }

        if ($dato['sucursal_exporto']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 97, $y);
            $pdf->printColor('', 8, '#FFFFFF', '#808080');
            $pdf->MultiCell($texX - 40, $texY, utf8_decode("Sucursal: " . $dato['sucursal_exporto']), 0, 'R', false);
        }

        if ($dato['proyecto']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 97, $y);
            $pdf->printColor('', 8, '#FFFFFF', '#808080');
            $pdf->MultiCell($texX - 40, $texY, utf8_decode("Proyecto: " . $dato['proyecto']), 0, 'R', false);
        }

        $CONTINUACION_Y3 = $pdf->GetY();

        // FIN DATOS IZQUIERDA

        // INICIO TABLA PRINCIPAL
        switch ($dato['SETTINGS']['size']) {
            case 'CartaVertical':
                $TPapelH = 191.6;
                $TPapelV = 245;
                $lineFin = $TPapelH;
                break;
            case 'CartaHorizontal':
                $TPapelH = 256;
                $TPapelV = 185;
                $lineFin = $TPapelH;
                break;
            case 'OficioVertical':
                $TPapelH = 191.6;
                $TPapelV = 325;
                $lineFin = $TPapelH;
                break;
            case 'OficioHorizontal':
                $TPapelH = 331.6;
                $TPapelV = 185;
                $lineFin = $TPapelH;
                break;
        }

        $x = 12;
        $yComo_supo_y_Cabecera = max($CONTINUACION_Y1, $CONTINUACION_Y2, $CONTINUACION_Y3) + 3;
        $pdf->SetY($yComo_supo_y_Cabecera);


        // CABECERA INICIO
        $y = $pdf->GetY();
        if ($TIPO_FORMS == "CABECERADTALLE" && $CD_Print == "ConDatos") {

            if ($dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_TITLE'] === true) {
                $pdf->SetXY($x, $y);
                $pdf->printColor('rojo', 10, $HEX01);
                $pdf->CellFitSpace($TPapelH - 50, 5, utf8_decode($dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['TITLE'] ?? 'C A B E C E R A'), "", 0, 'C', true);
                $y += $texY;
            }

            if ($dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_DATOS'] === true) {
                $pdf->SetXY($x, $y);
                $y = $pdf->GetY();
                $pdf->printColor('gris', 8, '#e5e5e5');
                self::CABECERA_DETALLE($pdf, $_CONFIGCELDA, $HTML_ETIQUETA_CABECERA, $TPapelH - 50, $y, $_EXCELCABECERADETALLE);
                $y = $pdf->GetY();
                $pdf->SetY($y + 5);
            }

        }

        $pdf->SetY($yComo_supo_y_Cabecera);

        self::COMO_SUPO_DE_NOSOTROS($pdf, $x, $yComo_supo_y_Cabecera, $TPapelH, $como_te_enteraste);

//        $yFacturaCotizacionRequerimientosTablaProductos = $pdf->GetY() + 5;
        $yFacturaCotizacionRequerimientosTablaProductos = $pdf->GetY();

//        self::FACTURA_COTIZACION($pdf, $x, $yFacturaCotizacionRequerimientosTablaProductos, null, null, $wTotalRequerimientoToDiffTablaProd, $dato);

        $wTotalRequerimientoToDiffTablaProd = 0;

        $y = $pdf->GetY();

//        self::TIPO_REQUERIMIENTOS($pdf, $x, $y, $TPapelH, $tipo_requerimiento, $wTotalRequerimientoToDiffTablaProd, $yUltimoRequerimiento, $dato);

        $yUltimoRequerimiento = $pdf->GetY();

        $xTable = $x;

        if (!$DATOSEXCEL) {
            $DATOSEXCEL = array();
        }

        if (!isset($_EXCELCABECERADETALLE)) {
            $_EXCELCABECERADETALLE = array();
        }


        $DATOSEXCEL['_EXCELCABECERADETALLE'] = $_EXCELCABECERADETALLE;
        // CABECERA FIN

        // DTALLE INICIO

        $xInicioTableProducto = $wTotalRequerimientoToDiffTablaProd;

        $TPapelHTableProducto = $TPapelH - $xInicioTableProducto;

        $pdf->SetY($yFacturaCotizacionRequerimientosTablaProductos + 5);

        if ($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_TITLE'] === true) {
            $y = $pdf->GetY();
            $pdf->SetXY($xTable, $y);
            $pdf->printColor('rojo', 10, $HEX01);
            $pdf->CellFitSpace($TPapelHTableProducto, 5, utf8_decode($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['TITLE'] ?? "D E T A L L E S"), "", 0, 'C', true);
        }

        $y = $pdf->GetY() + 5;

        $pdf->SetXY($xTable, $y);

        $w = $TPapelHTableProducto / count($HTML_ETIQUETA_DETALLE);

        if ($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_TITLE_TABLE'] === true) {
            $pdf->printColor('gris', 8, $HEX02);
            self::DetallesHeadTableProductos($pdf, $HTML_ETIQUETA_DETALLE, $w, 5, $xTable, $y, true, $TPapelHTableProducto, $_CONFIGCELDA, $_EXCELHEADERDETALLE);
            $DATOSEXCEL['EXCEL_HEADER_DETALLE'] = $_EXCELHEADERDETALLE;
            $y = $pdf->GetY() + 5;
        }


        if ($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_DATOS_TABLE'] === true) {
            self::DetallesBodyTableProductos($pdf, $dato, $HTML_CAMPOS_DETALLE, $HTML_CAMPOS_NODO, $HTML_ETIQUETA_DETALLE_NODO, $TPapelHTableProducto, $HTML_DATOS_DETALLE, $w, 5, $xTable, $y, $lineFin, $TPapelV, $_CONFIGCELDA, $_EXCELBODYDETALLE, $yUltimoProducto, $ultimoFormasDePago, $iva_total);
            $DATOSEXCEL['EXCEL_BODY_DETALLE'] = $_EXCELBODYDETALLE;
            $y = $pdf->GetY();
        }

        // DTALLE FIN

        // FIN TABLA PRINCIPAL

        // INICIO OBSERVACIONES

        $yUltimo = max($yUltimoProducto, $yUltimoRequerimiento);

        $yInit = $yUltimo - 3;
        $xInit = $pdf->GetX() + 2;
        $wTotal = $TPapelH;


        if ($dato["no_desglosar_iva"]) {
            $pdf->SetXY($xInit, $yInit);
            $pdf->SetFont('Arial', '', 7);
            $pdf->MultiCell($wTotal, 1, "Los importes se expresan en pesos mexicanos e incluyen IVA.", "", 'L', false);
        }

        self::OBSERVACIONES($pdf, $x, $TPapelH, $yUltimo, $dato, $yUltimoObservaciones);

        // FIN OBSERVACIONES

        $yUltimo = max($ultimoFormasDePago, $yUltimoObservaciones) - 2;

        $pdf->SetY($yUltimo);

        if ($dato['factura'] === 1 || $dato['nota_sencilla'] === 1 || $dato['interno'] === 1) {
            $ver_fimmas = true;
        } else {
            $ver_fimmas = false;
        }

        self::TEXTO_DISCLAIMER($pdf, $TPapelH, $ver_fimmas);

        if ($ver_fimmas) {
            self::RECIBO_FIRMA_AUTORIZACION($pdf, $TPapelH);
        }

        self::TEXTO_PAGINA_Y_RED_SOCIAL($pdf, $TPapelH);


        /*
         * FIN INFO SOCIAL
         * */

        // INICIO WATERMARCK
        $pdf->printWATERMARCK($_CONFIGCELDA, 1);
        // FIN WATERMARCK


        if ($dato['MARCA_TEXTO']['LABEL']) {
            $RGB = $pdf->HexToRgb(($dato['MARCA_TEXTO']['COLOR'] ?? "#000000"));
            $pdf->SetFont('Arial', 'B', 40);
            $pdf->SetTextColor($RGB['r'], $RGB['g'], $RGB['b']);
            $pdf->Rotate($dato['MARCA_TEXTO']['ANGLE'] ?? 45, $dato['MARCA_TEXTO']['X_INIT'] ?? 35, $dato['MARCA_TEXTO']['Y_INIT'] ?? 190);
            $pdf->Text($dato['MARCA_TEXTO']['X_INIT'] ?? 35, $dato['MARCA_TEXTO']['Y_INIT'] ?? 190, $dato['MARCA_TEXTO']['LABEL']);
            $pdf->Rotate(0);
        }

        // INICIO ETIQUETA FOOTER
        $y = -15;
        $x = 11.7;
        $pdf->SetY($y);
        $pdf->SetX($x);
        $pdf->SetFillColor(255, 255, 255);//Fondo gris
        $pdf->SetTextColor(10, 140, 223); //Letra color azul
        $pdf->SetFont('Arial', '', 8);
        $pdf->CellFitSpace($TPapelH, 3, $LINEAPUNTEADA . $LINEAPUNTEADA, 0, 0, 'C', true);
        $pdf->Ln();
        $pdf->SetTextColor(0, 0, 0); //Letra color azul
        $pdf->SetFont('Arial', '', 7);
        $pdf->CellFitSpace($TPapelH, 3, $INFOFOOTER[0], 0, 0, 'C', true);
        $pdf->Ln();
        $pdf->CellFitSpace($TPapelH, 3, $INFOFOOTER[1], 0, 0, 'C', true);
        $pdf->Ln();
        $pdf->SetFont('Arial', '', 4);
        $pdf->CellFitSpace($TPapelH, 3, utf8_decode(" O R I G I N A L"), 0, 0, 'R', true);

        // FIN ETIQUETA FOOTER
        // echo "<pre>";
        // print_r($DATOSEXCEL);
        // echo "</pre>";
        // exit();


        switch ($dato['SETTINGS']['type']) {
            case 'PDF':

                if ($dato['SETTINGS']['toEmail']) {

                    $root = env('DOC_TEMP_TO_PDF');

                    if (!is_dir($root)) {
                        mkdir($root, 0777);
                    }

                    $path = $root . ($dato['SETTINGS']['fileName'] ?? "file") . "-" . rand(10000, 99999) . rand(10000, 99999) . "-" . strtotime(date('Y-m-d H:i:s')) . ".pdf";

                    $pdf->Output($path, "F");

                    if (file_exists($path)) {
                        $result = array(
                            'success' => true,
                            'status' => 200,
                            'message' => 'Archivo creado con éxito.',
                            'data' => array(
                                "path" => $path,
                            )
                        );
                    } else {
                        $result = array(
                            'success' => false,
                            'status' => 400,
                            'message' => 'Error al crear el archivo.',
                            'data' => array()
                        );
                    }

                    return $result;

                } else {

                    switch ($dato['SETTINGS']['action']) {
                        case 'DESCARGAR':

                            $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                            $pdf->Output('D', utf8_decode($filename));

                            break;
                        case 'VER':

                            $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                            $pdf->Output('I', utf8_decode($filename));

                            break;
                        case 'IMPRIMIR':

                            $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                            $pdf->AutoPrint(true);
                            $pdf->Output('I', utf8_decode($filename));

                            break;
                    }

                }

                break;
            case 'EXCEL':

                dd('En Desarrollo, Exportacion en excel');

                break;
        }
    }

    /**
     ** Esto genera la parte de cabecera del detalle
     **/
    public static function CABECERA_DETALLE($pdf, $_CONFIGCELDA, $cabecera, $TPapelH, $y, &$_EXCELCABECERADETALLE)
    {

        $cantidad_row = 2;
        $cantidad_cell = 1;
        $wLabel = 25;
        $wValue = 75;

        $wL = (($wLabel * $TPapelH) / 100) / $cantidad_cell;
        $wV = (($wValue * $TPapelH) / 100) / $cantidad_cell;

//        dd($wL, $wV, $TPapelH);
        $_EXCELCABECERADETALLE = array();

        $pdf->SetY($y);

        if (count($cabecera) > 0) {
            /*Validar si es array la cabecera para evitar errores*/
            if (!is_array($cabecera)) {
                $cabecera = array();
            }

            if ($_CONFIGCELDA['SHOW_HIDDEN_COLUMNA_CABECERA'] != "") {
                $SHOW_HIDDEN_COLUMNA_CABECERA = explode(",", $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA_CABECERA']);
            } else {
                /*Para hacer visible celdas de cabecera detalle*/
                foreach ($cabecera as $key => $value) {
                    $SHOW_HIDDEN_COLUMNA_CABECERA[] = "SHOW";
                }
            }

            $COUN = 0;
            foreach ($cabecera as $key => $value) {
                if ($SHOW_HIDDEN_COLUMNA_CABECERA[$COUN] == "SHOW") {
                    $cabecera2[$key] = $value;
                }
                $COUN++;
            }

            if (is_array($cabecera2)) {
                $cabecera = $cabecera2;
            }

            /*Para dar el formato para imprimir las filas*/
            $k = 0;
            foreach ($cabecera as $key => $row) {
                $DATOSR[$k][] = utf8_decode($key . ":");
                $DATOSR[$k][] = utf8_decode($row);
                if (is_int((((int)$key + 1) / $cantidad_cell))) {
                    $k++;
                }
            }

            $_EXCELCABECERADETALLE = $DATOSR;

            /*Para meter otra daros a la fila cuando sea impar para que no se descuadre la cabecera*/
            $restante = 0;
            // Todo REVISAR AQUI EL FUNCIONAMIENTO de la variable $restante
            foreach ($DATOSR as $key => $row) {
                $conteocabecera = count($DATOSR[$key]);
                if ($conteocabecera < $cantidad_row) {
                    $restante = $cantidad_row - $conteocabecera;
                }
                for ($p = 0; $p < $restante; $p++) {
                    $DATOSR[$key][] = "";
                }
            }

            /*Para agregar el tamaño*/
            $k = 0;
            foreach ($DATOSR as $key => $value) {
                $tamanio[$k][] = $wL;
                $tamanio[$k][] = $wV;
                if (is_int((((int)$key + 1) / $cantidad_cell))) {
                    $k++;
                }
            }

            /*Para agregar la alineacion*/
            $k = 0;
            foreach ($DATOSR as $key => $value) {
                $aling[$k][] = 'L';
                $aling[$k][] = 'L';
                if (is_int((((int)$key + 1) / $cantidad_cell))) {
                    $k++;
                }
            }

            /*Para imprimir los datos fila por fila*/
            foreach ($DATOSR as $key => $row) {
                $pdf->SetFillColor(240, 240, 240); /*Fondo verde de celda*/
                $pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
                $pdf->SetTextColor(0, 0, 0); /*Letra color blanco*/

                $pdf->styleRect(0); /*margin de celdas*/
                $pdf->BorderTable(1); /*para activar color de la fila*/

                $pdf->SetWidths($tamanio[$key]); /*tamaño de celdas array*/
                $pdf->SetAligns($aling[$key]); /*alineacion de texto en celda array*/
                $pdf->SetFont('arial', '', 7);

                $pdf->SetLeftMargin(12);
                $pdf->Row($DATOSR[$key], 3.5);
            }

        }

    }

    public static function COMO_SUPO_DE_NOSOTROS($pdf, $x, $y, $TPapelH, $como_te_enteraste)
    {
        $wFill = 42;
        $hFill = 3;
        $xFull = $x + ($TPapelH - $wFill);
//        $yFull = $y + 1;
        $yFull = $y;

        $pdf->SetXY($xFull, $yFull);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell($wFill, $hFill, utf8_decode("¿Como supo de nosotros?"), 0, 0, 'R', true);
        $pdf->SetXY($xFull, $y + 2);

        foreach ($como_te_enteraste as $key => $row) {

            $checked = $row['checked'] ? '4' : '';
            $label = utf8_decode($row['label']);

            $y = $pdf->GetY();
            $pdf->SetXY($xFull, $y + 3.5);

            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            $pdf->SetFillColor(220, 220, 220);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('ZapfDingbats', '', 7);
            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);

            $pdf->SetFillColor(255, 255, 255);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell(30, $hFill, $label, 0, 0, 'L', false);

        }

        $pdf->Ln();
    }

    /**
     ** Esto genera la cabecera de la tabla
     **/
    public static function DetallesHeadTableProductos($pdf, $cabecera, $w, $h, $x, $y, $bandera = true, $TPapelH, $_CONFIGCELDA, &$_EXCELHEADERDETALLE)
    {

        if ($_CONFIGCELDA['TAMANIO_CELDA_DETALLE'] != "") {
            $tamanio = self::CalcularTamanios($_CONFIGCELDA['TAMANIO_CELDA_DETALLE'], $TPapelH);
        } else {
            foreach ($cabecera as $key => $value) {
                $tamanio[] = $w;
            }
        }

        if ($_CONFIGCELDA['ALINEACION_CELDA_DETELLE'] != "") {
            $aling = explode(",", $_CONFIGCELDA['ALINEACION_CELDA_DETELLE']);
        } else {
            foreach ($cabecera as $key => $value) {
                $aling[] = 'C';
            }
        }

        if ($_CONFIGCELDA['SHOW_HIDDEN_COLUMNA'] != "") {
            $hiddencelda = explode(",", $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA']);
        } else {
            foreach ($cabecera as $key => $value) {
                $hiddencelda[] = "SHOW";
            }
        }


        unset($filasCabeceras);
        foreach ($cabecera as $key => $fila) {
            if ($hiddencelda[$key] == "SHOW") {
                $filasCabeceras[] = utf8_decode($fila);
            }
        }

        // inicio cambio de posicion de las columnas
        if ($_CONFIGCELDA['POSICION_CELDA_DETALLE'] != "") {
            $position = explode(",", $_CONFIGCELDA['POSICION_CELDA_DETALLE']);
        } else {
            foreach ($cabecera as $key => $value) {
                $position[] = $key;
            }
        }

        foreach ($position as $key => $positionkey) {
            $filasCabecerasTemp[] = $filasCabeceras[$positionkey];
        }
        $filasCabeceras = $filasCabecerasTemp;
        $_EXCELHEADERDETALLE = $filasCabeceras;

        // fin cambio de posicion de las columnas

        // $this->SetFillColor(2,157,116); /*Fondo verde de celda este color viene de GeneratePDF*/
        $pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
        $pdf->SetTextColor(240, 255, 240); /*Letra color blanco*/

        $pdf->styleRect(0); /*margin de celdas*/
        $pdf->BorderTable(1); /*para activar color de la fila*/

        $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
        $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
        $pdf->SetFont('arial', 'B', 7);

        $pdf->SetLeftMargin(12);
        $pdf->Row($filasCabeceras, 3.5);
    }

    public static function CalcularTamanios($ALINEACION_CELDA_DETELLE, $TPapelH)
    {
        $N = array();
        $T = explode(",", $ALINEACION_CELDA_DETELLE);
        foreach ($T as $key => $porcentaje) {
            $N[] = ($TPapelH * $porcentaje) / 100;
        }
        return $N;
    }

    /**
     ** Esto genera el cuerpo de la tabla
     **/
    public static function DetallesBodyTableProductos($pdf, $dato, $HTML_CAMPOS, $HTML_CAMPOS_NODO, $HTML_ETIQUETA_NODO, $TPapelH, $HTML_DATOS, $w, $h, $x, $y, $lineFin, $TPapelV, $_CONFIGCELDA, &$_EXCELBODYDETALLE, &$yUltimoProducto, &$ultimoFormasDePago, &$iva_total)
    {
        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->SetFont('Arial', '', 6);
        $pdf->SetTextColor(3, 3, 3); //Color del texto: Negro
        $bandera = true; //Para alternar el relleno
        $numero = 1;

        /*
         * INICIO TABLA NORMAL:: TABLA DETALLE
         * */

        if (!is_array($HTML_CAMPOS)) {
            $HTML_CAMPOS = array();
        }

        if (!is_array($HTML_DATOS)) {
            $HTML_DATOS = array();
        }

        if ($_CONFIGCELDA['TAMANIO_CELDA_DETALLE_RESUMEN'] != "") {
            $tamanio = self::CalcularTamanios($_CONFIGCELDA['TAMANIO_CELDA_DETALLE_RESUMEN'], $TPapelH);
        } else {
            foreach ($HTML_CAMPOS as $key => $value) {
                $tamanio[] = $w;
            }
        }

        if ($_CONFIGCELDA['ALINEACION_CELDA_DETELLE'] != "") {
            $aling = explode(",", $_CONFIGCELDA['ALINEACION_CELDA_DETELLE']);
        } else {
            foreach ($HTML_CAMPOS as $key => $value) {
                $aling[] = 'C';
            }
        }


        if ($_CONFIGCELDA['SHOW_HIDDEN_COLUMNA'] != "") {
            $hiddencelda = explode(",", $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA']);
        } else {
            foreach ($HTML_CAMPOS as $key => $value) {
                $hiddencelda[] = "SHOW";
            }
        }

        // inicio cambio de posicion de las columnas
        if ($_CONFIGCELDA['POSICION_CELDA_DETALLE'] != "") {
            $position = explode(",", $_CONFIGCELDA['POSICION_CELDA_DETALLE']);
        } else {
            foreach ($HTML_CAMPOS as $key => $value) {
                $position[] = $key;
            }
        }

        /*
         * FIN TABLA NORMAL:: TABLA DETALLE
         * */

        // fin cambio de posicion de las columnas
        $keyDATOEXCEL = 0;
        foreach ($HTML_DATOS as $key1 => $row1) {
            unset($datosarray);
            foreach ($HTML_CAMPOS as $key2 => $row2) {
                if ($hiddencelda[$key2] == "SHOW") {
                    $datosarray[] = html_entity_decode(utf8_decode($row1[$row2['NOMBRE']])); //promero codifica los acentos y caracteres especiales, despues decodifica los entites de html
                }
            }

            // inicio cambio de posicion de las columnas
            unset($datosarrayTemp);
            foreach ($position as $key => $positionkey) {
                $datosarrayTemp[] = $datosarray[$positionkey];
            }
            $datosarray = $datosarrayTemp;
            $_EXCELBODYDETALLE[$keyDATOEXCEL] = $datosarray;
            $_EXCELBODYDETALLE[$keyDATOEXCEL]['_NODO'] = "";
            // fin cambio de posicion de las columnas


            $pdf->SetXY($x, $pdf->GetY());

            $pdf->SetFillColor(240, 240, 240); /*Fondo gris de celda*/
            $pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
            $pdf->SetTextColor(0, 0, 0); /*Letra color blanco*/

            $pdf->styleRect($bandera); /*margin de celdas*/
            $pdf->BorderTable($bandera); /*para activar color de la fila*/

            $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
            $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
            $pdf->SetFont('arial', '', 7);

            $pdf->SetLeftMargin(12);
            $pdf->Row($datosarray, 3.5);

            // INICIO WATERMARCK
            $pdf->printWATERMARCK($_CONFIGCELDA);
            // FIN WATERMARCK

            $bandera = !$bandera;

            $keyDATOEXCEL++;
        }


        if ($pdf->PageNo() == 1) {
            $LimitPagePrintFila = 6 - count($HTML_DATOS);

            for ($numero = 0; $numero <= $LimitPagePrintFila; $numero++) {
                unset($datosarray);
                foreach ($HTML_CAMPOS as $key2 => $row2) {
                    $datosarray[] = "";
                }

                $pdf->SetFillColor(240, 240, 240); /*Fondo gris de celda*/
                $pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
                $pdf->SetTextColor(0, 0, 0); /*Letra color blanco*/

                $pdf->styleRect($bandera); /*margin de celdas*/
                $pdf->BorderTable($bandera); /*para activar color de la fila*/

                $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
                $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
                $pdf->SetFont('arial', 'B', 7);

                $pdf->SetX($x);
                $pdf->SetLeftMargin(10);
                $pdf->Row($datosarray, 3.5);

                $bandera = !$bandera;
            }
        }

        $yUltimoProducto = $pdf->GetY() + 5;

        $es_nota_o_factura = false;

        if ($dato['cotizacion']) {
            $es_nota_o_factura = false;
        }

        if ($dato['interno']) {
            $es_nota_o_factura = true;
        }

        if ($dato['nota_sencilla']) {
            $es_nota_o_factura = true;
        }

        if ($dato['factura']) {
            $es_nota_o_factura = true;
        }

        $anticipo = $dato['anticipo'];

        $total = 0;
        $iva = 16;

        foreach ($HTML_DATOS as $key => $row) {
            $total += $row['venta_precio_normal'];
        }

        //dd($HTML_DATOS);

        $descuento = $dato['no_desglosar_iva'] ? $dato['descuento'] * 1.16 : $dato['descuento'];
        $subtotal = $dato['no_desglosar_iva'] ? $total : ($total / (($iva / 100) + 1));
        $total = $dato['total'];
        $iva_total = $total - ($subtotal - $descuento);
        $total_pagado = $dato['total_pagado'];

        if ($descuento > 0) {
            $rowDesglose[] = array(
                0 => "",
                1 => "",
                2 => "",
                3 => "",
                4 => $dato["no_desglosar_iva"] ? "SUB. TOTAL:":"SUB. TOTAL (SIN DESC.):",
                5 => "$" . number_format($subtotal, 2)
            );

            $rowDesglose[] = array(
                0 => "",
                1 => "",
                2 => "",
                3 => "",
                4 => "DESCUENTO:",
                5 => "$" . number_format($descuento, 2)
            );
        }

        if (!$dato["no_desglosar_iva"]) {
            $rowDesglose[] = array(
                0 => "",
                1 => "",
                2 => "",
                3 => "",
                4 => "SUB. TOTAL:",
                5 => "$" . number_format($subtotal - $descuento, 2)
            );

            $rowDesglose[] = array(
                0 => "",
                1 => "",
                2 => "",
                3 => "",
                4 => "I.V.A. " . $iva . "%:",
                5 => "$" . number_format($iva_total, 2)
            );
        }

        $rowDesglose[] = array(
            0 => "",
            1 => "",
            2 => "",
            3 => "",
            4 => "TOTAL:",
            5 => "$" . number_format($dato["no_desglosar_iva"] ? $subtotal - $descuento : $total, 2)
        );


        if ($es_nota_o_factura) {
            $rowDesglose[] = array(
                0 => "",
                1 => "",
                2 => "",
                3 => "",
                4 => "",
                5 => ""
            );
            $rowDesglose[] = array(
                0 => "",
                1 => "",
                2 => "",
                3 => "",
                4 => "ANTICIPO:",
                5 => "$" . number_format($anticipo, 2)
            );
            $rowDesglose[] = array(
                0 => "",
                1 => "",
                2 => "",
                3 => "",
                4 => "POR PAGAR:",
                5 => "$" . number_format($total - $total_pagado, 2)
            );
        }

        /*
         * INICIO DESGLOSE DE TOTALES
         * */

        foreach ($rowDesglose as $key => $desglose) {
            $pdf->SetFillColor(240, 240, 240); /*Fondo gris de celda*/
            $pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
            $pdf->SetTextColor(0, 0, 0); /*Letra color blanco*/

            $pdf->styleRect(0); /*margin de celdas*/
            $pdf->BorderTable(0); /*para activar color de la fila*/

            $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
            $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
            $pdf->SetFont('arial', 'B', 7);

            $pdf->SetX($x);
            $pdf->SetLeftMargin(10);
            $pdf->Row($desglose, 3.5);
        }

        /*
         * INICIO DESGLOSE DE TOTALES
         * */


        /*
         * INICIO TEXTOS
         * */

        $pdf->SetY($pdf->GetY() + 2);

        $wTotal = array_reverse($tamanio)[0] + array_reverse($tamanio)[1];

        $xInitExtra = $x + (array_sum($tamanio) - $wTotal);

        $y = $pdf->GetY();
        $pdf->SetXY($xInitExtra, $y);
        $pdf->SetFont('arial', '', 6.5);
        $TXT = "1.- Todo trabajo requiere un 50 % de anticipo";
        $pdf->MultiCell($wTotal, 3, $pdf->DecodeText($TXT), 0, 'R', false);

        $y = $pdf->GetY();
        $pdf->SetXY($xInitExtra, $y);
        $pdf->SetFont('arial', '', 6.5);
        $TXT = "2.- Precios sujetos a cambio sin previo aviso";
        $pdf->MultiCell($wTotal, 3, $pdf->DecodeText($TXT), 0, 'R', false);

        $y = $pdf->GetY();
        $pdf->SetXY($xInitExtra, $y);
        $pdf->SetFont('arial', '', 5.5);
        $TXT = "¡DISEÑAMOS AL GUSTO DE NUESTROS CLIENTES!";
        $pdf->MultiCell($wTotal, 3, $pdf->DecodeText($TXT), 0, 'R', false);

        /*
         * FIN TEXTOS
         * */


        /*
         * INICIO PAGO EFECTIVO O TRANSFERENCIA
         * */

        $hFill = 3;
        $wFill = ($wTotal - 2) - $hFill;
        $pdf->SetY($pdf->GetY() - 4);

        /*
         * Efectivo
         * */

//        $efectivo = ($dato['pago_efectivo'] == 1);
//
//        if ($efectivo) {
//
//            $y = $pdf->GetY() + 6;
//            $pdf->SetXY($xInitExtra + 2, $y);
//
//            $checked = $efectivo ? '4' : '';
//            $label = strtoupper(utf8_decode('Pago en efectivo'));
//
//            $pdf->SetFillColor(255, 255, 255);
//            $pdf->SetTextColor(0, 0, 0);
//            $pdf->SetFont('Arial', '', 8);
//            $pdf->Cell($wFill - 1, $hFill, $label, 0, 0, 'L', false);
//
//            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
//            $pdf->SetFillColor(220, 220, 220);
//            $pdf->SetTextColor(0, 0, 0);
//            $pdf->SetFont('ZapfDingbats', '', 6);
//            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);
//
//        }

        /*
         * Transferencia
         * */

//        $transferencia = ($dato['pago_transferencia'] == 1);
//
//        if ($transferencia) {
//
//            $y = $pdf->GetY() + 4;
//            $pdf->SetXY($xInitExtra + 2, $y);
//
//            $checked = $transferencia ? '4' : '';
//            $label = strtoupper(utf8_decode('Pago con transferencia'));
//
//            $pdf->SetFillColor(255, 255, 255);
//            $pdf->SetTextColor(0, 0, 0);
//            $pdf->SetFont('Arial', '', 8);
//            $pdf->Cell($wFill - 1, $hFill, $label, 0, 0, 'L', false);
//
//            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
//            $pdf->SetFillColor(220, 220, 220);
//            $pdf->SetTextColor(0, 0, 0);
//            $pdf->SetFont('ZapfDingbats', '', 6);
//            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);
//
//        }

        /*
         * pago_tarjeta_debito
         * */

//        $tarjeta_debito = ($dato['pago_tarjeta_debito'] == 1);
//
//        if ($tarjeta_debito) {
//
//            $y = $pdf->GetY() + 4;
//            $pdf->SetXY($xInitExtra + 2, $y);
//
//            $checked = $tarjeta_debito ? '4' : '';
//            $label = strtoupper(utf8_decode('Pago con tarjeta de débito'));
//
//            $pdf->SetFillColor(255, 255, 255);
//            $pdf->SetTextColor(0, 0, 0);
//            $pdf->SetFont('Arial', '', 8);
//            $pdf->Cell($wFill - 1, $hFill, $label, 0, 0, 'L', false);
//
//            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
//            $pdf->SetFillColor(220, 220, 220);
//            $pdf->SetTextColor(0, 0, 0);
//            $pdf->SetFont('ZapfDingbats', '', 6);
//            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);
//
//        }

        /*
         * pago_tarjeta_debito
         * */

//        $tarjeta_credito = ($dato['pago_tarjeta_credito'] == 1);
//
//        if ($tarjeta_credito) {
//
//            $y = $pdf->GetY() + 4;
//            $pdf->SetXY($xInitExtra + 2, $y);
//
//            $checked = $tarjeta_credito ? '4' : '';
//            $label = strtoupper(utf8_decode('Pago con tarjeta de crédito'));
//
//            $pdf->SetFillColor(255, 255, 255);
//            $pdf->SetTextColor(0, 0, 0);
//            $pdf->SetFont('Arial', '', 8);
//            $pdf->Cell($wFill - 1, $hFill, $label, 0, 0, 'L', false);
//
//            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
//            $pdf->SetFillColor(220, 220, 220);
//            $pdf->SetTextColor(0, 0, 0);
//            $pdf->SetFont('ZapfDingbats', '', 6);
//            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);
//
//        }

        $pdf->Ln(3);

        if (count($dato['formas_de_pago']) > 0) {
            $y = $pdf->GetY() + 4;
            $pdf->SetXY($xInitExtra + 2, $y);

            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            $pdf->SetFillColor(255, 255, 255);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell($wFill + 4, $hFill, "FORMAS DE PAGO:", 0, 0, 'R', false);

            $pdf->Ln(1);
        }

        foreach ($dato['formas_de_pago'] as $key => $row) {

            $y = $pdf->GetY() + 4;
            $pdf->SetXY($xInitExtra + 2, $y);

            $checked = '4';
            $label = strtoupper(utf8_decode($row['forma_pago']));
            $monto = strtoupper(utf8_decode($row['total']));

            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            $pdf->SetFillColor(255, 255, 255);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell($wFill - 20, $hFill, $label, 0, 0, 'L', false);

            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            $pdf->SetFillColor(255, 255, 255);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell(20, $hFill, $monto, 0, 0, 'R', false);

            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            $pdf->SetFillColor(220, 220, 220);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('ZapfDingbats', '', 6);
            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);

        }

        /*
         * Para regresar a usar la FUENTE arial
         * */
        $pdf->Ln(10);

        $pdf->SetFont('Arial', '', 8);

        $ultimoFormasDePago = $pdf->GetY() + 5;

        /*
         * FIN PAGO EFECTIVO O TRANSFERENCIA
         * */

        // INICIO WATERMARCK
        $pdf->printWATERMARCK($_CONFIGCELDA);
        // FIN WATERMARCK

    }

    public static function OBSERVACIONES($pdf, &$x, $TPapelH, $yUltimo, $dato, &$yUltimoObservaciones)
    {


        $pdf->Ln();

        $yInit = $yUltimo;
        $xInit = $pdf->GetX() + 2;
        $wTotal = $TPapelH - (($TPapelH * 30) / 100);

        $observacion = $dato['observaciones'] . '
        ';

        $pdf->SetDrawColorHex("#E6E6E6");
        $pdf->SetFillColorHex("#F2F2F2");


        $pdf->SetXY($xInit, $yInit);
        $pdf->SetTextColorHex("#666666");
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell($wTotal, 5 + 3, "OBSERVACIONES:", "LTR", 0, 'L', true);


        $pdf->SetXY($xInit, $pdf->GetY() + 6);
        $pdf->SetTextColorHex("#333333");
        $pdf->SetFont('Arial', '', 8);
        $pdf->MultiCell($wTotal, 4, $pdf->DecodeText($observacion), "LBR", 'L', true);

        $x = $xInit + $wTotal; // retoranara la cordaneada en x en la que se quedo para continuar apartir de ahi con la impresion de la tabla de productoss

        $yUltimoObservaciones = $pdf->GetY() + 5;

        $pdf->Ln();

        $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
    }

    public static function TEXTO_DISCLAIMER($pdf, $TPapelH, $ver_fimmas)
    {

        if ($ver_fimmas) {
            $limite = 215;
        } else {
            $limite = 229;
        }

        if ($pdf->GetY() <= $limite) {
            $pdf->SetY($limite);
        }

        if ($pdf->GetY() > $limite) {
            $pdf->AddPage();
        }

        $TXT01 = "El cliente manifiesta bajo protesta de decir verdad que la denominación, elementos, diseño, marca y/o logo del cual solicita el trabajo y/o servicio son de su propiedad y/o autoría, se encuentra legalmente autorizado o no tiene restricción legal para emplearlos, por lo que no existe violación alguna a Derechos de autor, ni a la Ley de Propiedad Industrial ni a su respectivo reglamento, por lo que exime a la empresa Mark Desing de toda responsabilidad por el uso o reproducción de los mismos en base al servicio o trabajo que ampara esta orden, siendo completa responsabilidad del cliente el uso y/o reproducción que se solicita.";
        $TXT02 = "Mark Desing no reconoce autoría ni derecho alguno al cliente respecto a la denominación, elementos, diseño, marca y/o logo del cual solicita el servicio, limitándose a realizar el trabajo que ampara esta orden en la forma y términos solicitados por el cliente, sin que Mark Desing haga uso alguno de ellos.";
        $TXT03 = "Mark Desing se reserva el derecho de no realizar o suspender cualquier trabajo en cuanto se percate de la violación de derechos de autor o de propiedad industrial, y dar aviso a la autoridad competente por las infracciones cometidas.";

        $borde_boolena = false;
        $bg_boolean = false;

        $pdf->SetX(12);
        $pdf->printColor(null, 7, '#ffffff', '#505050');
        $pdf->MultiCell($TPapelH, 3, $pdf->DecodeText($TXT01), $borde_boolena, 'L', $bg_boolean);

        $pdf->SetX(12);
        $pdf->printColor(null, 7, '#ffffff', '#505050');
        $pdf->MultiCell($TPapelH, 3, $pdf->DecodeText($TXT02), $borde_boolena, 'L', $bg_boolean);

        $pdf->SetX(12);
        $pdf->printColor(null, 7, '#ffffff', '#505050');
        $pdf->MultiCell($TPapelH, 3, $pdf->DecodeText($TXT03), $borde_boolena, 'L', $bg_boolean);

        $pdf->Ln();
    }

    public static function RECIBO_FIRMA_AUTORIZACION($pdf, $TPapelH)
    {

        $xmargen = 12;
        $ancho = 40;
        $separacion = 10;


        $iY = $pdf->GetY();
        $iX = (($TPapelH - $separacion) / 2) - $ancho;

        $BOX01[0] = $xmargen + $iX;
        $BOX01[1] = $iY;

        $BOX02[0] = $xmargen + $iX + $separacion + $ancho;
        $BOX02[1] = $iY;


        $pdf->SetDrawColor(250, 250, 250); /*Color margin de celdas*/
        $pdf->SetFillColor(220, 220, 220);
        $pdf->SetTextColor(0, 0, 0);

        $pdf->SetXY($BOX01[0], $BOX01[1]);
        $pdf->Cell($ancho, 10, "", 1, 0, 'C', true);

        $pdf->SetXY($BOX01[0], $BOX01[1] + 11);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell($ancho, 3, strtoupper(utf8_decode('RECIBIDO')), 0, 1, 'C', false);


        $pdf->SetDrawColor(250, 250, 250); /*Color margin de celdas*/
        $pdf->SetFillColor(220, 220, 220);
        $pdf->SetTextColor(0, 0, 0);

        $pdf->SetXY($BOX02[0], $BOX02[1]);
        $pdf->Cell($ancho, 10, "", 1, 0, 'C', true);

        $pdf->SetXY($BOX02[0], $BOX02[1] + 11);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell($ancho, 3, strtoupper(utf8_decode('FIRMA DE AUTORIZACIÓN')), 0, 1, 'C', false);


    }

    public static function TEXTO_PAGINA_Y_RED_SOCIAL($pdf, $TPapelH)
    {

        $TXT0 = "";
        $TXT1 = "IMPRESIÓN DIGITAL | CORTE | MAQUILA DE TEXTILES | SUBLIMADO";
        $TXT2 = "markdeirapuato";
        $TXT3 = "markirapuato";
        $TXT4 = "462 335 8381";
        $TXT5 = "";

        $facebook = env('DOC_IMAGE_TO_PDF') . 'social/facebook_1.png';
        $instagram = env('DOC_IMAGE_TO_PDF') . 'social/instagram_1.png';
        $internet = env('DOC_IMAGE_TO_PDF') . 'social/whatsapp_1.png';

        $yUltimo = $pdf->GetY() + 5;

        $activar_borde = false;
        $activar_bg = false;
        $separacion_extra = 2;
        $separacion_extra_left_right = 7.4;

        /*
         * Separacion izquierda ...*/
        $x0 = 12;
        $ancho0 = $separacion_extra_left_right;

        /*
         * Texto IMPRESIÓN DIGITAL ...*/
        $x1 = $x0 + $ancho0;
        $ancho1 = 93 + $separacion_extra;

        /*
         * Texto FACEBOOK ...*/
        $x2 = $x1 + $ancho1;
        $ancho2 = 7;

        $x3 = $x2 + $ancho2;
        $ancho3 = 20 + $separacion_extra;

        /*
         * Texto INSTAGRAM ...*/
        $x4 = $x3 + $ancho3;
        $ancho4 = 7;

        $x5 = $x4 + $ancho4;
        $ancho5 = 17 + $separacion_extra;

        /*
         * Texto INTERNET ...*/
        $x6 = $x5 + $ancho5;
        $ancho6 = 7;

        $x7 = $x6 + $ancho6;
        $ancho7 = 18 + $separacion_extra;

        /*
         * Separacion derecha ...*/
        $x8 = $x7 + $ancho7;
        $ancho8 = $separacion_extra_left_right;


        $pdf->SetXY($x0, $yUltimo);
        $pdf->Cell($ancho0, 3, utf8_decode($TXT0), $activar_borde, 0, 'C', $activar_bg);

        $pdf->SetXY($x1, $yUltimo);
        $pdf->Cell($ancho1, 3, utf8_decode($TXT1), $activar_borde, 0, 'C', $activar_bg);

        $pdf->SetXY($x2, $yUltimo);
        $pdf->Image($facebook, $x2 + 2.5, $yUltimo, 3, 3);

        $pdf->SetXY($x3, $yUltimo);
        $pdf->Cell($ancho3, 3, utf8_decode($TXT2), $activar_borde, 0, 'C', $activar_bg);

        $pdf->SetXY($x4, $yUltimo);
        $pdf->Image($instagram, $x4 + 2.5, $yUltimo, 3, 3);

        $pdf->SetXY($x5, $yUltimo);
        $pdf->Cell($ancho5, 3, utf8_decode($TXT3), $activar_borde, 0, 'C', $activar_bg);

        $pdf->SetXY($x6, $yUltimo);
        $pdf->Image($internet, $x6 + 2.5, $yUltimo, 3, 3);

        $pdf->SetXY($x7, $yUltimo);
        $pdf->Cell($ancho7, 3, utf8_decode($TXT4), $activar_borde, 0, 'C', $activar_bg);

        $pdf->SetXY($x8, $yUltimo);
        $pdf->Cell($ancho8, 3, utf8_decode($TXT5), $activar_borde, 0, 'C', $activar_bg);

        $pdf->Ln();

    }

    public static function RECIBO_FIRMA_AUTORIZACION_TICKET($pdf, $TPapelH)
    {

        $xmargen = 0;
        $ancho = 0;
        $separacion = 10;


        $iY = $pdf->GetY();
        $iX = (($TPapelH - $separacion) / 2) - $ancho;

        $BOX01[0] = $xmargen + $iX;
        $BOX01[1] = $iY;

        $BOX02[0] = $xmargen + $iX + $separacion + $ancho;
        $BOX02[1] = $iY;

        $pdf->SetXY($BOX01[0], $BOX01[1]);
        $pdf->Cell($ancho, 10, "", 1, 0, 'C', true);

        $pdf->SetXY($BOX01[0], $BOX01[1] + 11);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell($ancho, 3, strtoupper(utf8_decode('RECIBIDO')), 0, 1, 'C', false);

        $pdf->SetXY($BOX02[0], $BOX02[1]);
        $pdf->Cell($ancho, 10, "", 1, 0, 'C', true);

        $pdf->SetXY($BOX02[0], $BOX02[1] + 11);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell($ancho, 3, strtoupper(utf8_decode('FIRMA DE AUTORIZACIÓN')), 0, 1, 'C', false);


    }

    public static function FACTURA_COTIZACION($pdf, $x, $y, $factura = false, $cotizacion = false, &$wTotalRequerimientoToDiffTablaProd, $dato)
    {
        $pdf->SetXY($x, $y + 3);
        $wFillFactura = 17;
        $wFillCotizacion = 20;
        $hFill = 3;

        /*
         * Factura
         * */

        $factura = ($dato['factura'] == 1);

        $checked = $factura ? '4' : '';
        $label = strtoupper(utf8_decode('Factura'));

        $pdf->SetXY($pdf->GetX(), $pdf->GetY());

        $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
        $pdf->SetFillColor(220, 220, 220);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('ZapfDingbats', '', 6);
        $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);

        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell($wFillFactura, $hFill, $label, 0, 0, 'L', false);

        /*
         * Cotización
         * */

        $cotizacion = ($dato['cotizacion'] == 1);

        $checked = $cotizacion ? '4' : '';
        $label = strtoupper(utf8_decode('Cotización'));

        $pdf->SetXY($pdf->GetX(), $pdf->GetY());

        $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
        $pdf->SetFillColor(220, 220, 220);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('ZapfDingbats', '', 6);
        $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);

        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell($wFillCotizacion, $hFill, $label, 0, 0, 'L', false);

        $pdf->Ln();

        $wTotalRequerimientoToDiffTablaProd = $hFill + $wFillFactura + $hFill + $wFillCotizacion;
    }

    public static function TIPO_REQUERIMIENTOS($pdf, &$x, $y, $TPapelH, $tipo_requerimiento, $wTotalRequerimientoToDiffTablaProd, &$yUltimoRequerimiento, $dato)
    {
        $xInit = $x;
        $yInit = $y;
        $pdf->SetXY($xInit, $yInit);
        $hFill = 3;
        $wFill = $wTotalRequerimientoToDiffTablaProd - $hFill;

        foreach ($tipo_requerimiento as $key => $row) {

            $checked = $row['checked'] ? '4' : '';
            $label = strtoupper(utf8_decode($row['label']));

            $y = $pdf->GetY();
            $pdf->SetXY($xInit, $y + 4);

            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            $pdf->SetFillColor(220, 220, 220);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('ZapfDingbats', '', 6);
            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);

            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            $pdf->SetFillColor(255, 255, 255);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell($wFill, $hFill, $label, 0, 0, 'L', false);

        }

        $wTotal = $wFill + $hFill;

        $y = $pdf->GetY();
        $pdf->SetXY($xInit, $y + 7);

        $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell($wTotal - 2, $hFill + 3, "OTROS:", "LTR", 0, 'L', false);


        $y = $pdf->GetY();
        $pdf->SetXY($xInit, $y + 6);

        $pdf->MultiCell($wTotal - 2, 4, $pdf->DecodeText($dato['cliente_deja_anexo'] . ' ' . $dato['cliente_envia_muestra_por_correo']), "LBR", 'L', false);


        /*
         * FINALIZAR SECCION
         * */
        $x = $xInit + $wTotal; // retoranara la cordaneada en x en la que se quedo para continuar apartir de ahi con la impresion de la tabla de productoss

        $pdf->Ln();
        $yUltimoRequerimiento = $pdf->GetY();
    }

    public static function GenerateTICKET($dato, $TAM_H_mm = 85, $TAM_W_mm = 58)
    {

        foreach ($dato['VENTA']['DETALLE'] as $key => $row) {
            $cantidadchar = strlen($row['PRODUCTO']);
            $cantidadchar = number_format($cantidadchar / 30);
            if ($cantidadchar == 0) {
                $cantidadchar = 1;
            }
            $TAM_H_mm = $TAM_H_mm + ($cantidadchar * 2.5);
        }

//        define("FONT_TICKET_B", "courier");
//        define("FONT_TICKET_R", "courier");

        define("FONT_TICKET_B", "helvetica");
        define("FONT_TICKET_R", "helvetica");

//        define("FONT_TICKET_B", "times");
//        define("FONT_TICKET_R", "times");

//        define("FONT_TICKET_B", "AGENCYB");
//        define("FONT_TICKET_R", "AGENCYR");

//        define("FONT_TICKET_B", "Arial");
//        define("FONT_TICKET_R", "Arial");
        $SIZEFONTDETALLE = 6.5;
        $LIMITACION = 0;
        $TPapelTiket = array($TAM_W_mm, $TAM_H_mm);

        $pdf = new PDF('P', 'mm', $TPapelTiket);
        $pdf->AddPage();


        #Establecemos los márgenes izquierda, arriba y derecha:
        $pdf->SetMargins(2, 3, 2);
        #Establecemos el margen inferior:
        $pdf->SetAutoPageBreak(true, 3);


        // INICIO LOGO
        $cw = 2;
        $ch = 3;
        $wi = 15;
        $hi = 9;
        if ($dato['INFO']['EMPRESA_LOGO'] != "") {
            if (file_exists(env('DOC_IMAGE_TO_PDF') . $dato['INFO']['EMPRESA_LOGO'])) {
                $pdf->Image(env('DOC_IMAGE_TO_PDF') . $dato['INFO']['EMPRESA_LOGO'], $cw, $ch, $wi, $hi);
            }
        }
        // FIN LOGO

        // INICIO VARIABLES
        $x = 2;
        $y = 3;
        $texX = 54;
        $texY = 2.2;
        $pdf->SetXY($x, $y);
        // FIN VARIABLES

        // INICIO DATOS DERECHA

        if ($dato['INFO']['EMPRESA_RAZON_SOCIAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 15, $y);
            $pdf->printColorTicket('negro', 7, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY + 1, $pdf->DecodeText($dato['INFO']['EMPRESA_RAZON_SOCIAL']), $LIMITACION, 'L', false);
        }

        // $pdf->Cell(0,2, "Your Name", '1', 2, 'L', false); //Name

        if ($dato['INFO']['EMPRESA_SUCURSAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 15, $y);
            $pdf->printColorTicket('negro', 6, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY + 1, $pdf->DecodeText($dato['INFO']['EMPRESA_SUCURSAL']), $LIMITACION, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_RFC']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 15, $y);
            $pdf->printColorTicket('negro', 5, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY + 1, $pdf->DecodeText($dato['INFO']['EMPRESA_RFC']), $LIMITACION, 2, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_DIRECCION']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 10, $y);
            $pdf->printColorTicket('negro', 5, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_DIRECCION']), $LIMITACION, 'C', false);
            $pdf->Ln();
        }

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "- * - * - * - * - * - * - * - * - * - * - * - * - * - * - * - * -", $LIMITACION, 'C', false);

        // FIN DATOS DERECHA

        // INICIO DATOS CABECERA
        $y = $pdf->GetY() + 3;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "Folio: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['FOLIO']), $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "TICKET: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['FOLIO_TICKET']), $LIMITACION, 'C', false);

        $y = $pdf->GetY() + 3;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "Fecha: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['FECHA_REGISTRO']), $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "Cliente: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['NOMBRE_COMERCIAL']), $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "Forma de pago: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['FORMA_PAGO']), $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "Metodo de pago: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['METODO_PAGO']), $LIMITACION, 'C', false);

//        $y = $pdf->GetY();
//        $pdf->SetXY($x, $y);
//        $pdf->printColorTicket('negro', 5, '#ffffff');
//        $pdf->MultiCell($texX, $texY, "Almacen: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['ALMACEN']), $LIMITACION, 'C', false);

//        $y = $pdf->GetY();
//        $pdf->SetXY($x, $y);
//        $pdf->printColorTicket('negro', 5, '#ffffff');
//        $pdf->MultiCell($texX, $texY, "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -", $LIMITACION, 'C', false);

        $pdf->Ln();

        // FIN DATOS CABECERA
        // INICIO HEADER TABLE TICKET
        $filasCabeceras = array(
            'Producto',
            'Importe'
        );

        $tamanio = array(35, 19);
        $aling = array('L', 'R');


        $pdf->styleRect($LIMITACION); /*margin de celdas*/
        $pdf->BorderTable($LIMITACION); /*para activar color de la fila*/

        $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
        $pdf->SetAligns($aling); /*alineacion de texto en celda array*/

        $pdf->SetFont(FONT_TICKET_R, '', $SIZEFONTDETALLE - 1);

        $pdf->Row($filasCabeceras);
        // FIN HEADER TABLE TICKET

//        // INICIO HEADER TABLE TICKET
        foreach ($dato['VENTA']['DETALLE'] as $key => $row) {

            $filasCabeceras = array(
                utf8_decode($row['PRODUCTO']),
                number_format($row['IMPORTE'], 2)
            );

            $aling = array('L', 'R');

            $pdf->styleRect($LIMITACION); /*margin de celdas*/
            $pdf->BorderTable($LIMITACION); /*para activar color de la fila*/

            $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
            $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
            $pdf->SetFont(FONT_TICKET_R, '', $SIZEFONTDETALLE - 1);

            $pdf->Row($filasCabeceras, 2.5);
        }

        // FIN HEADER TABLE TICKET

        $TOTAL = $dato['TOTAL'];
        $EFECTIVO = $dato['EFECTIVO'];
        $EFECTIVO_CAMBIO = $dato['EFECTIVO_CAMBIO'];

        // INICIO DATOS FOOTHER TICKETS
        $y = $pdf->GetY() - 1.5;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "- - - - - - - - - - -", $LIMITACION, 'R', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX - 15, $texY, "TOTAL:", $LIMITACION, 'R', false);
        $pdf->SetXY($x + $texX - 15, $y);
        $pdf->MultiCell(15, $texY, number_format($TOTAL, 2), $LIMITACION, 'R', false);

        if ($dato['ID_CAT_FORMA_PAGO'] === 1) {

            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColorTicket('negro', 5, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY, "EFECTIVO:", $LIMITACION, 'R', false);
            $pdf->SetXY($x + $texX - 15, $y);
            $pdf->MultiCell(15, $texY, number_format($EFECTIVO, 2), $LIMITACION, 'R', false);

            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColorTicket('negro', 5, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY, "EFECTIVO CAMBIO:", $LIMITACION, 'R', false);
            $pdf->SetXY($x + $texX - 15, $y);
            $pdf->MultiCell(15, $texY, number_format($EFECTIVO_CAMBIO, 2), $LIMITACION, 'R', false);

        }

        $pdf->Ln();

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "Total con letra: " . $pdf->num2letras(str_replace("$", "", str_replace(",", "", number_format($TOTAL ?? 0.001, 4)))), $LIMITACION, 'C', false);

//        $y = $pdf->GetY();
//        $pdf->SetXY($x, $y + 5);
//        $pdf->printColorTicket('negro', 7, '#ffffff');
//        $pdf->MultiCell($texX, $texY, "Gracias por su compra!!", $LIMITACION, 'C', false);

//        $y = $pdf->GetY();
//        $pdf->SetXY($x, $y + 5);
//        $pdf->printColorTicket('negro', 5, '#ffffff');
//        $pdf->MultiCell($texX, $texY, "Te esperamos pronto en " . $dato['INFO']['EMPRESA_NOMBRE_COMERCIAL'], $LIMITACION, 'C', false);

        $y = $pdf->GetY() + 3;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, utf8_decode("Visítanos en: " . $dato['INFO']['EMPRESA_PAGINA_WEB']), $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "E-Mail: " . $dato['INFO']['EMPRESA_CORREO_ELECTRONICO'], $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, $dato['INFO']['EMPRESA_TELEFONO'], $LIMITACION, 'C', false);

        // FIN DATOS FOOTHER TICKETS

        // INICIO ETIQUETA FOOTER
        $y = $pdf->GetY() + 5;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, utf8_decode("Fecha de impresión " . date("Y-m-d H:i:s")), $LIMITACION, 'R', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - O R I G I N A L", $LIMITACION, 'C', false);
        // FIN ETIQUETA FOOTER

        switch ($dato['SETTINGS']['action']) {
            case 'DESCARGAR':
                $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                $pdf->Output('D', utf8_decode($filename));
                break;
            case 'VER':
                $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                $pdf->Output('I', utf8_decode($filename));
                break;
            case 'IMPRIMIR':
                $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                $pdf->AutoPrint(true);
                $pdf->Output('I', utf8_decode($filename));
                break;
        }
        exit();
    }

    public static function GenerateTICKETVENTA($dato, $como_te_enteraste, $tipo_requerimiento, &$DATOSEXCEL)
    {
        //$dato, $TAM_H_mm = 85, $TAM_W_mm = 58)
//        dd($dato);

        $TAM_H_mm = 300;
        foreach ($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_DATOS'] as $key => $row) {
            $cantidadchar = strlen($row['venta_producto']);
            $cantidadchar = number_format($cantidadchar / 30);
            if ($cantidadchar == 0) {
                $cantidadchar = 1;
            }
            $TAM_H_mm = $TAM_H_mm + ($cantidadchar * 2.5);
        }


        $HEX01 = $dato['INFO']['CONFIGURACION']['COLOR_PRIMARIO'];

        $HEX02 = $dato['INFO']['CONFIGURACION']['COLOR_SECUNDARIO'];

        if ($HEX02 == "" || $HEX01 == "") {
            $dato['INFO']['CONFIGURACION']['COLOR_PRIMARIO'] = '#E4100A';
            $dato['INFO']['CONFIGURACION']['COLOR_SECUNDARIO'] = '#25A79F';
        }

        $_CONFIGCELDA['TAMANIO_CELDA_DETALLE'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['TAMANIO_CELDA_DETALLE'];
        $_CONFIGCELDA['ALINEACION_CELDA_DETELLE'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['ALINEACION_CELDA_DETELLE'];
        $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_HIDDEN_COLUMNA_DETALLE'];
        $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA_NODO'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_HIDDEN_COLUMNA_DETALLE_NODO'];

        $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA_CABECERA'] = $dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_HIDDEN_COLUMNA_CABECERA'];

        $_CONFIGCELDA['MARCA_DE_AGUA'] = $dato['INFO']['CONFIGURACION']['MARCA_DE_AGUA'];
        if ($dato['INFO']['CONFIGURACION']['POSICION_LOGO']) {
            $_CONFIGCELDA['POSICION_LOGO'] = $dato['INFO']['CONFIGURACION']['POSICION_LOGO'];
        } else {
            $_CONFIGCELDA['POSICION_LOGO'] = "RIGHT";
        }
        $_CONFIGCELDA['POSICION_CELDA_DETALLE'] = $dato['INFO']['CONFIGURACION']['POSICION_CELDA_DETALLE'];

        $_CONFIGCELDA['POSICION_CELDA_DETALLE_NODO'] = $dato['INFO']['CONFIGURACION']['POSICION_CELDA_DETALLE_NODO'];

        $_CONFIGCELDA['TEXTO_EXTRA'] = $dato['INFO']['CONFIGURACION']['TEXTO_EXTRA'];

        if ($dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_TITLE'] || $dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_DATOS']) {

            $TIPO_FORMS = "CABECERADTALLE";

            /*
             * FUNCIONALIDAD CABECERA
             * */

            $HTML_ETIQUETA_CABECERA = $dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['DATOS'];
            $CD_Print = "Vacio";

            foreach ($HTML_ETIQUETA_CABECERA as $key => $val) {
                if ($val != "" && $val != NULL) {
                    $CD_Print = "ConDatos";
                }
            }

            /*
             * FUNCIONALIDAD DETALLE
             * */

            $HTML_ETIQUETA_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_ETIQUETA'];
            $HTML_CAMPOS_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_CAMPOS'];

            $HTML_ETIQUETA_DETALLE_NODO = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_ETIQUETA_NODO'];
            $HTML_CAMPOS_NODO = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_CAMPOS_NODO'];

            $HTML_DATOS_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_DATOS'];

        } else {

            $TIPO_FORMS = "DETALLE";

            /*
             * FUNCIONALIDAD CABECERA
             * */

            $HTML_ETIQUETA_CABECERA = array();
            $CD_Print = "Vacio";

            /*
             * FUNCIONALIDAD DETALLE
             * */

            $HTML_ETIQUETA_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_ETIQUETA'];
            $HTML_CAMPOS_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_CAMPOS'];

            $HTML_ETIQUETA_DETALLE_NODO = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_ETIQUETA_NODO'];
            $HTML_CAMPOS_NODO = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_CAMPOS_NODO'];

            $HTML_DATOS_DETALLE = $dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['HTML_DATOS'];
        }

        switch ($dato['SETTINGS']['size']) {
            case 'CartaVertical':
                $pdf = new PDF('P', 'mm', 'Letter');
                $CANPUNTO = 150;
                break;
            case 'CartaHorizontal':
                $pdf = new PDF('L', 'mm', 'Letter');
                $CANPUNTO = 150;
                break;
            case 'OficioVertical':
                $pdf = new PDF('P', 'mm', 'legal');
                $CANPUNTO = 150;
                break;
            case 'OficioHorizontal':
                $pdf = new PDF('L', 'mm', 'legal');
                $CANPUNTO = 150;
                break;
            case 'TicketVertical':
                $TPapelTiket = array(72, $TAM_H_mm);
                $pdf = new PDF('P', 'mm', $TPapelTiket);
                $CANPUNTO = 150;
                break;
        }

        $LINEAPUNTEADA = '';

        for ($PUN = 0; $PUN < $CANPUNTO; $PUN++) {
            $LINEAPUNTEADA .= " - ";
        }

        $LINEAPUNTEADA = trim($LINEAPUNTEADA);

        $pdf->setDATOS($dato);
        $pdf->setReferenceWatermark(1);
        $pdf->AliasNbPages();
        $pdf->AddPage();
        $pdf->SetAutoPageBreak(false, 5);

        $INFOFOOTER[0] = $pdf->DecodeText($dato['INFO']['EMPRESA_RAZON_SOCIAL']);
        $INFOFOOTER[1] = $pdf->DecodeText($dato['INFO']['EMPRESA_DIRECCION']);
        $INFOFOOTER[2] = $pdf->DecodeText(" | " . $pdf->DecodeText($dato['INFO']['EMPRESA_TELEFONO']) . " | " . $pdf->DecodeText($dato['INFO']['EMPRESA_PAGINA_WEB']));

        // INICIO LOGO
        switch ($_CONFIGCELDA['POSICION_LOGO']) {
            case 'RIGHT':
                switch ($dato['SETTINGS']['size']) {
                    case 'CartaVertical':
                        $cw = 161.5;
                        break;
                    case 'CartaHorizontal':
                        $cw = 226;
                        break;
                    case 'OficioVertical':
                        $cw = 161.5;
                        break;
                    case 'OficioHorizontal':
                        $cw = 301.5;
                        break;
                    case 'TicketVertical':
                        $cw = 80;
                        break;
                }

                $ch = 12;

                $wi = 40;
                $hi = 25;
                break;
            case 'LEFT':
                $cw = 2;
                $ch = 5;

                $wi = 14;
                $hi = 11;
                break;
        }



        if ($dato['INFO']['EMPRESA_LOGO'] != "") {
            $rootlogo = env('DOC_IMAGE_TO_PDF') . 'logonegro.png';
            if (file_exists($rootlogo)) {
                $pdf->Image($rootlogo, $cw, $ch, $wi, $hi);
            }
        }

        $CONTINUACION_Y1 = ($ch + $hi);
        // FIN LOGO


        // INICIO VARIABLES
        $x = 7;
        $y = 5;
        $texX = 55;
        $texY = 3;

        $pdf->SetXY($x, $y);
        // FIN VARIABLES

        // INICIO DATOS DERECHA
        switch ($_CONFIGCELDA['POSICION_LOGO']) {
            case 'RIGHT':
                $x = $x;
                break;
            case 'LEFT':
                $x = $x + 10;
                break;
        }

        /*if ($dato['INFO']['EMPRESA_NOMBRE_COMERCIAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negro', 7, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_NOMBRE_COMERCIAL']), 0, 'L', false);
        }*/
        $pdf->SetFont('Helvetica');
        if ($dato['INFO']['EMPRESA_RAZON_SOCIAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negro', 9, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_RAZON_SOCIAL']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_SUCURSAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_SUCURSAL']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_CLAVE']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_CLAVE']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_RFC']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_RFC']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_DIRECCION']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negroregular', 7, '#ffffff');
            $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_DIRECCION']), 0, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_TELEFONO'] && $dato['INFO']['EMPRESA_CORREO_ELECTRONICO']) {

            if ($dato['INFO']['EMPRESA_TELEFONO']) {
                $y = $pdf->GetY();
                $pdf->SetXY($x, $y);
                $pdf->printColor('negroregular', 7, '#ffffff');
                $pdf->MultiCell($texX, $texY, $pdf->DecodeText("Tel.: " . $dato['INFO']['EMPRESA_TELEFONO'] . "   Email: " . $dato['INFO']['EMPRESA_CORREO_ELECTRONICO']), 0, 'L', false);
            }

        } else {

            if ($dato['INFO']['EMPRESA_TELEFONO']) {
                $y = $pdf->GetY();
                $pdf->SetXY($x, $y);
                $pdf->printColor('negroregular', 7, '#ffffff');
                $pdf->MultiCell($texX, $texY, $pdf->DecodeText("Tel.: " . $dato['INFO']['EMPRESA_TELEFONO']), 0, 'L', false);
            }

            if ($dato['INFO']['EMPRESA_CORREO_ELECTRONICO']) {
                $y = $pdf->GetY();
                $pdf->SetXY($x, $y);
                $pdf->printColor('negroregular', 7, '#ffffff');
                $pdf->MultiCell($texX, $texY, $pdf->DecodeText("Email: " . $dato['INFO']['EMPRESA_CORREO_ELECTRONICO']), 0, 'L', false);
            }

        }

        $CONTINUACION_Y2 = $pdf->GetY();
        // FIN DATOS DERECHA

        // INICIO VARIABLES
        $x = 1;
        $y = 25;
        switch ($dato['SETTINGS']['size']) {
            case 'CartaVertical':
                $texX = 97.8;
                break;
            case 'CartaHorizontal':
                $texX = 155;
                break;
            case 'OficioVertical':
                $texX = 230;
                $texX = 97.8;
                break;
            case 'OficioHorizontal':
                $texX = 238;
                break;
            case 'TicketVertical':
                $texX = 5;
                break;
        }
        $texY = 3;
        $texX = 5;

        $pdf->SetXY($x, $y);
        // FIN VARIABLES

        if ($dato['folio']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negro', 8, '#FFFFFF');
            $pdf->MultiCell($texX - 5, $texY, "Folio: " . utf8_decode($dato['folio']), 0, 'L', true);
        }

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColor('negro', 6, '#ffffff');
        $pdf->MultiCell($texX - 5, $texY, utf8_decode($dato['title']), 0, 'L', false);

        if ($dato['pedido']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negro', 7, '#ffffff');
            $pdf->MultiCell($texX - 5, $texY, "# " . utf8_decode($dato['pedido']), 0, 'L', true);
        }

        $texX = 53;
        $texY = 3;

        $pdf->SetXY($x, $y - 6);

        // INICIO DATOS IZQUIERDA
        switch ($_CONFIGCELDA['POSICION_LOGO']) {
            case 'RIGHT':
                $x = $x;
                break;
            case 'LEFT':
                $x = $x + 20;
                break;
        }


        if ($dato['fecha_alta']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->printColor('negro', 7, '#ffffff');
            $pdf->MultiCell($texX - 5, $texY, utf8_decode("Fecha alta: " . $dato['fecha_alta']), 0, 'R', true);
        }

        if ($dato['fecha_entrega']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->MultiCell($texX - 5, $texY, utf8_decode("Fecha entrega: " . $dato['fecha_entrega']), 0, 'R', true);
        }

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->MultiCell($texX - 5, $texY, utf8_decode("Fecha de exportación: " . date("d-m-Y")), 0, 'R', false);

        if ($dato['usuario_exporto']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x, $y);
            $pdf->MultiCell($texX - 5, $texY, utf8_decode("Usuario: " . $dato['usuario_exporto']), 0, 'R', false);
        }

        if ($dato['sucursal_exporto']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 5, $y);
            $pdf->MultiCell($texX - 5, $texY, utf8_decode("Sucursal: " . $dato['sucursal_exporto']), 0, 'R', false);
        }

        if ($dato['proyecto']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 5, $y);
            $pdf->MultiCell($texX - 5, $texY, utf8_decode("Proyecto: " . $dato['proyecto']), 0, 'R', false);
        }

        $CONTINUACION_Y3 = $pdf->GetY();

        // FIN DATOS IZQUIERDA

        // INICIO TABLA PRINCIPAL
        switch ($dato['SETTINGS']['size']) {
            case 'CartaVertical':
                $TPapelH = 191.6;
                $TPapelV = 245;
                $lineFin = $TPapelH;
                break;
            case 'CartaHorizontal':
                $TPapelH = 256;
                $TPapelV = 185;
                $lineFin = $TPapelH;
                break;
            case 'OficioVertical':
                $TPapelH = 191.6;
                $TPapelV = 325;
                $lineFin = $TPapelH;
                break;
            case 'OficioHorizontal':
                $TPapelH = 331.6;
                $TPapelV = 185;
                $lineFin = $TPapelH;
                break;
            case 'TicketVertical':
                $TPapelH = 71;
                $TPapelV = 185;
                $lineFin = $TPapelH;
                break;
        }

        $x = 2;
        $yComo_supo_y_Cabecera = max($CONTINUACION_Y1, $CONTINUACION_Y2, $CONTINUACION_Y3) + 3;
        $pdf->SetY($yComo_supo_y_Cabecera);


        // CABECERA INICIO
        $y = $pdf->GetY();
        $pdf->SetLeftMargin(1);
        if ($TIPO_FORMS == "CABECERADTALLE" && $CD_Print == "ConDatos") {

            if ($dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_TITLE'] === true) {
                $pdf->SetXY(0, $y);
                $pdf->printColor('negro', 7, '#ffffff');
                $pdf->CellFitSpace($TPapelH, 4, utf8_decode($dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['TITLE'] ?? 'C A B E C E R A'), "", 0, 'C', true);
                $y += $texY;
            }

            if ($dato['CONFIGURAR_DATOS_ETIQUETAS_CABECERAS']['SHOW_DATOS'] === true) {
                $pdf->SetXY(0, $y + 3);
                $y = $pdf->GetY();
                self::CABECERA_DETALLE_TICKET($pdf, $_CONFIGCELDA, $HTML_ETIQUETA_CABECERA, $TPapelH, $y, $_EXCELCABECERADETALLE);
                $y = $pdf->GetY();
                $pdf->SetY($y);
            }

        }

        $pdf->SetY($yComo_supo_y_Cabecera);

        $TPapelH = $pdf->GetY();
        self::COMO_SUPO_DE_NOSOTROS_TICKET($pdf, $x, $yComo_supo_y_Cabecera, $TPapelH, $como_te_enteraste);

//        $yFacturaCotizacionRequerimientosTablaProductos = $pdf->GetY() + 5;
        $yFacturaCotizacionRequerimientosTablaProductos = $pdf->GetY();

//        self::FACTURA_COTIZACION($pdf, $x, $yFacturaCotizacionRequerimientosTablaProductos, null, null, $wTotalRequerimientoToDiffTablaProd, $dato);

        $wTotalRequerimientoToDiffTablaProd = 0;

        $y = $pdf->GetY();

//        self::TIPO_REQUERIMIENTOS($pdf, $x, $y, $TPapelH, $tipo_requerimiento, $wTotalRequerimientoToDiffTablaProd, $yUltimoRequerimiento, $dato);

        $yUltimoRequerimiento = $pdf->GetY();

        $xTable = $x;

        if (!$DATOSEXCEL) {
            $DATOSEXCEL = array();
        }

        if (!isset($_EXCELCABECERADETALLE)) {
            $_EXCELCABECERADETALLE = array();
        }

        $DATOSEXCEL['_EXCELCABECERADETALLE'] = $_EXCELCABECERADETALLE;
        // CABECERA FIN

        // DTALLE INICIO

        $xInicioTableProducto = $wTotalRequerimientoToDiffTablaProd;

        $TPapelHTableProducto = 65;

        $pdf->SetY($yFacturaCotizacionRequerimientosTablaProductos);

        if ($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_TITLE'] === true) {
            $y = $pdf->GetY();
            $pdf->SetXY(0, $y + 2);
            $pdf->printColor('negro', 5, '#ffffff', '#000000');
            $pdf->CellFitSpace($TPapelHTableProducto + 7, 5, utf8_decode($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['TITLE'] ?? "D E T A L L E S"), "", 0, 'C', true);
        }

        $y = $pdf->GetY() + 5;

        $pdf->SetXY($xTable, $y);

        $w = $TPapelHTableProducto / count($HTML_ETIQUETA_DETALLE);

        if ($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_TITLE_TABLE'] === true) {
            self::DetallesHeadTableProductosTicket($pdf, $HTML_ETIQUETA_DETALLE, $w, 5, $xTable, $y, true, $TPapelHTableProducto, $_CONFIGCELDA, $_EXCELHEADERDETALLE);
            $DATOSEXCEL['EXCEL_HEADER_DETALLE'] = $_EXCELHEADERDETALLE;
            $y = $pdf->GetY() + 5;
        }


        if ($dato['CONFIGURAR_DATOS_ETIQUETAS_DETALLES']['SHOW_DATOS_TABLE'] === true) {
            self::DetallesBodyTableProductosTicket($pdf, $dato, $HTML_CAMPOS_DETALLE, $HTML_CAMPOS_NODO, $HTML_ETIQUETA_DETALLE_NODO, $TPapelHTableProducto, $HTML_DATOS_DETALLE, 1, 5, $xTable, $y, $lineFin, $TPapelV, $_CONFIGCELDA, $_EXCELBODYDETALLE, $yUltimoProducto, $ultimoFormasDePago);
            $DATOSEXCEL['EXCEL_BODY_DETALLE'] = $_EXCELBODYDETALLE;
            $y = $pdf->GetY();
        }

        // INICIO OBSERVACIONES

        $yUltimo = max($yUltimoProducto, $y);
        self::OBSERVACIONESTICKET($pdf, $x, $TPapelHTableProducto, $yUltimo, $dato, $yUltimoObservaciones);

        // FIN OBSERVACIONES

        $yUltimo = max($ultimoFormasDePago, $yUltimoObservaciones) - 2;

        $pdf->SetY($yUltimo);

        if ($dato['factura'] === 1 || $dato['nota_sencilla'] === 1 || $dato['interno'] === 1) {
            $ver_fimmas = true;
        } else {
            $ver_fimmas = false;
        }

        self::TEXTO_DISCLAIMER_TICKET($pdf, $TPapelHTableProducto, $ver_fimmas);

        /* if ($ver_fimmas) {
             self::RECIBO_FIRMA_AUTORIZACION_TICKET($pdf, $TPapelH);
         }*/

//        self::TEXTO_PAGINA_Y_RED_SOCIAL($pdf, $TPapelH);

        /*
         * FIN INFO SOCIAL
         * */

        $TPapelHTableProducto = 66;
        // INICIO ETIQUETA FOOTER
        $y = $pdf->GetY() + 2;
        $x = 2;
        $pdf->SetY($y);
        $pdf->SetX($x);

        if ($dato['MARCA_TEXTO']['LABEL']) {
            $pdf->SetFont('Arial', 'B', 18);
            $pdf->CellFitSpace($TPapelHTableProducto, 6, utf8_decode($dato['MARCA_TEXTO']['LABEL']), 0, 0, 'C', true);
            //$pdf->CellFitSpace($TPapelHTableProducto, 5, $dato['MARCA_TEXTO']['LABEL'], 0, 0, 'C', true);
            $pdf->Ln();
        }

        //$pdf->SetFillColor(255, 255, 255);//Fondo gris
        //$pdf->SetTextColor(10, 140, 223); //Letra color azul

        $pdf->SetFont('Arial', '', 9);
        $pdf->CellFitSpace($TPapelHTableProducto, 5, $LINEAPUNTEADA . $LINEAPUNTEADA, 0, 0, 'C', true);
        $pdf->Ln();
        $pdf->SetTextColor(0, 0, 0); //Letra color azul
        $pdf->SetFont('Arial', '', 7);
        $pdf->CellFitSpace($TPapelHTableProducto, 5, $INFOFOOTER[0], 0, 0, 'C', true);
        $pdf->Ln();
        $pdf->MultiCell($TPapelHTableProducto, 3, $INFOFOOTER[1], 0, 'C', false);
        //$pdf->Cell($TPapelHTableProducto, 3, $INFOFOOTER[1], 0, 0, 'C', true);
        $pdf->CellFitSpace($TPapelHTableProducto, 3, $INFOFOOTER[2], 0, 0, 'C', true);
        $pdf->Ln();
        $pdf->SetFont('Arial', '', 6);
        $pdf->CellFitSpace($TPapelHTableProducto, 5, utf8_decode(" O R I G I N A L"), 0, 0, 'R', true);
        $pdf->Ln(1);

        // FIN ETIQUETA FOOTER


        switch ($dato['SETTINGS']['type']) {
            case 'PDF':

                if ($dato['SETTINGS']['toEmail']) {

                    $root = env('DOC_TEMP_TO_PDF');

                    if (!is_dir($root)) {
                        mkdir($root, 0777);
                    }

                    $path = $root . ($dato['SETTINGS']['fileName'] ?? "file") . "-" . rand(10000, 99999) . rand(10000, 99999) . "-" . strtotime(date('Y-m-d H:i:s')) . ".pdf";

                    $pdf->Output($path, "F");

                    if (file_exists($path)) {
                        $result = array(
                            'success' => true,
                            'status' => 200,
                            'message' => 'Archivo creado con éxito.',
                            'data' => array(
                                "path" => $path,
                            )
                        );
                    } else {
                        $result = array(
                            'success' => false,
                            'status' => 400,
                            'message' => 'Error al crear el archivo.',
                            'data' => array()
                        );
                    }

                    return $result;

                } else {

                    switch ($dato['SETTINGS']['action']) {
                        case 'DESCARGAR':

                            $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                            $pdf->Output('D', utf8_decode($filename));

                            break;
                        case 'VER':

                            $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                            $pdf->Output('I', utf8_decode($filename));

                            break;
                        case 'IMPRIMIR':

                            $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                            $pdf->AutoPrint(true);
                            $pdf->Output('I', utf8_decode($filename));

                            break;
                    }

                }

                break;
            case 'EXCEL':

                dd('En Desarrollo, Exportacion en excel');

                break;
        }
    }

    public static function CABECERA_DETALLE_TICKET($pdf, $_CONFIGCELDA, $cabecera, $TPapelH, $y, &$_EXCELCABECERADETALLE)
    {

        $cantidad_row = 2;
        $cantidad_cell = 1;
        $wLabel = 40;
        $wValue = 40;

        $wL = (($wLabel * $TPapelH) / 100) / $cantidad_cell;
        $wV = (($wValue * $TPapelH) / 100) / $cantidad_cell;

//        dd($wL, $wV, $TPapelH);
        $_EXCELCABECERADETALLE = array();

        $pdf->SetY($y);

        if (count($cabecera) > 0) {
            /*Validar si es array la cabecera para evitar errores*/
            if (!is_array($cabecera)) {
                $cabecera = array();
            }

            if ($_CONFIGCELDA['SHOW_HIDDEN_COLUMNA_CABECERA'] != "") {
                $SHOW_HIDDEN_COLUMNA_CABECERA = explode(",", $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA_CABECERA']);
            } else {
                /*Para hacer visible celdas de cabecera detalle*/
                foreach ($cabecera as $key => $value) {
                    $SHOW_HIDDEN_COLUMNA_CABECERA[] = "SHOW";
                }
            }

            $COUN = 0;
            foreach ($cabecera as $key => $value) {
                if ($SHOW_HIDDEN_COLUMNA_CABECERA[$COUN] == "SHOW") {
                    $cabecera2[$key] = $value;
                }
                $COUN++;
            }

            if (is_array($cabecera2)) {
                $cabecera = $cabecera2;
            }

            /*Para dar el formato para imprimir las filas*/
            $k = 0;
            foreach ($cabecera as $key => $row) {
                $DATOSR[$k][] = utf8_decode($key . ":");
                $DATOSR[$k][] = utf8_decode($row);
                if (is_int((((int)$key + 1) / $cantidad_cell))) {
                    $k++;
                }
            }

            $_EXCELCABECERADETALLE = $DATOSR;

            /*Para meter otra daros a la fila cuando sea impar para que no se descuadre la cabecera*/
            $restante = 0;
            // Todo REVISAR AQUI EL FUNCIONAMIENTO de la variable $restante
            foreach ($DATOSR as $key => $row) {
                $conteocabecera = count($DATOSR[$key]);
                if ($conteocabecera < $cantidad_row) {
                    $restante = $cantidad_row - $conteocabecera;
                }
                for ($p = 0; $p < $restante; $p++) {
                    $DATOSR[$key][] = "";
                }
            }

            /*Para agregar el tamaño*/
            $k = 0;
            foreach ($DATOSR as $key => $value) {

                $tamanio[$k][] = $wL;
                $tamanio[$k][] = $wV;
                if (is_int((((int)$key + 1) / $cantidad_cell))) {
                    $k++;
                }
            }

            /*Para agregar la alineacion*/
            $k = 0;
            foreach ($DATOSR as $key => $value) {
                $aling[$k][] = 'L';
                $aling[$k][] = 'L';
                if (is_int((((int)$key + 1) / $cantidad_cell))) {
                    $k++;
                }
            }
            /*Para imprimir los datos fila por fila*/
            foreach ($DATOSR as $key => $row) {

                //$pdf->SetFillColor(240, 240, 240); /*Fondo verde de celda*/
                //$pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
                //$pdf->SetTextColor(0, 0, 0); /*Letra color blanco*/

                $pdf->styleRect(0); /*margin de celdas*/
                $pdf->BorderTable(1); /*para activar color de la fila*/

                $pdf->SetWidths($tamanio[$key]); /*tamaño de celdas array*/
                $pdf->SetAligns('L'); /*alineacion de texto en celda array*/
                $pdf->printColor('negro', 5, '#ffffff', '#000000');


                $pdf->Row($DATOSR[$key], 3);

            }

        }

    }

    public static function COMO_SUPO_DE_NOSOTROS_TICKET($pdf, $x, $y, $TPapelH, $como_te_enteraste)
    {
        $wFill = 28;
        $hFill = 3;
        $y = $y + 30;
        $xFull = $x;
//        $yFull = $y + 1;
        $yFull = $y;

        $pdf->SetXY($xFull, $yFull);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->printColor('negro', 6, '#ffffff', '#000000');
        $pdf->Cell($wFill, $hFill, utf8_decode("¿Como supo de nosotros?"), 0, 0, 'R', true);
        $pdf->SetXY($xFull, $y + 2);

        foreach ($como_te_enteraste as $key => $row) {

            $checked = $row['checked'] ? 'X' : '';
            $label = utf8_decode($row['label']);

            if ($key % 3 == 0) {
                $y = $pdf->GetY();
                $xF = $xFull;
            } else {
                $xF = $xF + $xFull + 23;
            }


            $pdf->SetXY($xF, $y + 3.5);

            $pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            $pdf->SetTextColor(0, 0, 0);
            $pdf->printColor('negro', 5, '#ffffff', '#000000');
            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'C', true);
            $pdf->Cell(30, $hFill, $label, 0, 0, 'L', false);

        }

        $pdf->Ln();
    }

    public static function DetallesHeadTableProductosTicket($pdf, $cabecera, $w, $h, $x, $y, $bandera = true, $TPapelH, $_CONFIGCELDA, &$_EXCELHEADERDETALLE)
    {

        if ($_CONFIGCELDA['TAMANIO_CELDA_DETALLE'] != "") {
            $tamanio = self::CalcularTamanios($_CONFIGCELDA['TAMANIO_CELDA_DETALLE'], $TPapelH);
        } else {
            foreach ($cabecera as $key => $value) {
                $tamanio[] = $w;
            }
        }

        if ($_CONFIGCELDA['ALINEACION_CELDA_DETELLE'] != "") {
            $aling = explode(",", $_CONFIGCELDA['ALINEACION_CELDA_DETELLE']);
        } else {
            foreach ($cabecera as $key => $value) {
                $aling[] = 'C';
            }
        }

        if ($_CONFIGCELDA['SHOW_HIDDEN_COLUMNA'] != "") {
            $hiddencelda = explode(",", $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA']);
        } else {
            foreach ($cabecera as $key => $value) {
                $hiddencelda[] = "SHOW";
            }
        }


        unset($filasCabeceras);
        foreach ($cabecera as $key => $fila) {
            if ($hiddencelda[$key] == "SHOW") {
                $filasCabeceras[] = utf8_decode($fila);
            }
        }

        // inicio cambio de posicion de las columnas
        if ($_CONFIGCELDA['POSICION_CELDA_DETALLE'] != "") {
            $position = explode(",", $_CONFIGCELDA['POSICION_CELDA_DETALLE']);
        } else {
            foreach ($cabecera as $key => $value) {
                $position[] = $key;
            }
        }

        foreach ($position as $key => $positionkey) {
            $filasCabecerasTemp[] = $filasCabeceras[$positionkey];
        }
        $filasCabeceras = $filasCabecerasTemp;
        $_EXCELHEADERDETALLE = $filasCabeceras;

        // fin cambio de posicion de las columnas

        // $this->SetFillColor(2,157,116); /*Fondo verde de celda este color viene de GeneratePDF*/
        //$pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
        //$pdf->SetTextColor(240, 255, 240); /*Letra color blanco*/

        $pdf->styleRect(0); /*margin de celdas*/
        $pdf->BorderTable(1); /*para activar color de la fila*/

        $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
        $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
        $pdf->printColor('negro', 4, '#ffffff', '#000000');

        $pdf->SetLeftMargin(0);
        $pdf->Row($filasCabeceras, 3);
    }

    public static function DetallesBodyTableProductosTicket($pdf, $dato, $HTML_CAMPOS, $HTML_CAMPOS_NODO, $HTML_ETIQUETA_NODO, $TPapelH, $HTML_DATOS, $w, $h, $x, $y, $lineFin, $TPapelV, $_CONFIGCELDA, &$_EXCELBODYDETALLE, &$yUltimoProducto, &$ultimoFormasDePago)
    {

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->SetFont('Arial', '', 6);
        //$pdf->SetTextColor(3, 3, 3); //Color del texto: Negro
        $bandera = true; //Para alternar el relleno
        $numero = 1;


        /*
         * INICIO TABLA NORMAL:: TABLA DETALLE
         * */

        if (!is_array($HTML_CAMPOS)) {
            $HTML_CAMPOS = array();
        }

        if (!is_array($HTML_DATOS)) {
            $HTML_DATOS = array();
        }

        if ($_CONFIGCELDA['TAMANIO_CELDA_DETALLE'] != "") {
            $tamanio = self::CalcularTamanios($_CONFIGCELDA['TAMANIO_CELDA_DETALLE'], $TPapelH);
        } else {
            foreach ($HTML_CAMPOS as $key => $value) {
                $tamanio[] = $w;
            }
        }

        if ($_CONFIGCELDA['ALINEACION_CELDA_DETELLE'] != "") {
            $aling = explode(",", $_CONFIGCELDA['ALINEACION_CELDA_DETELLE']);
        } else {
            foreach ($HTML_CAMPOS as $key => $value) {
                $aling[] = 'C';
            }
        }


        if ($_CONFIGCELDA['SHOW_HIDDEN_COLUMNA'] != "") {
            $hiddencelda = explode(",", $_CONFIGCELDA['SHOW_HIDDEN_COLUMNA']);
        } else {
            foreach ($HTML_CAMPOS as $key => $value) {
                $hiddencelda[] = "SHOW";
            }
        }

        // inicio cambio de posicion de las columnas
        if ($_CONFIGCELDA['POSICION_CELDA_DETALLE'] != "") {
            $position = explode(",", $_CONFIGCELDA['POSICION_CELDA_DETALLE']);
        } else {
            foreach ($HTML_CAMPOS as $key => $value) {
                $position[] = $key;
            }
        }

        /*
         * FIN TABLA NORMAL:: TABLA DETALLE
         * */

        // fin cambio de posicion de las columnas
        $keyDATOEXCEL = 0;

        foreach ($HTML_DATOS as $key1 => $row1) {
            unset($datosarray);
            foreach ($HTML_CAMPOS as $key2 => $row2) {
                if ($hiddencelda[$key2] == "SHOW") {
                    $datosarray[] = html_entity_decode(utf8_decode($row1[$row2['NOMBRE']])); //promero codifica los acentos y caracteres especiales, despues decodifica los entites de html
                }
            }
            // inicio cambio de posicion de las columnas
            unset($datosarrayTemp);
            foreach ($position as $key => $positionkey) {
                $datosarrayTemp[] = $datosarray[$positionkey];
            }
            $datosarray = $datosarrayTemp;
            $_EXCELBODYDETALLE[$keyDATOEXCEL] = $datosarray;
            $_EXCELBODYDETALLE[$keyDATOEXCEL]['_NODO'] = "";
            // fin cambio de posicion de las columnas


            $pdf->SetXY($x, $pdf->GetY());

            //$pdf->SetFillColor(240, 240, 240); /*Fondo gris de celda*/
            //$pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
            //$pdf->SetTextColor(0, 0, 0); /*Letra color blanco*/

            $pdf->styleRect($bandera); /*margin de celdas*/
            $pdf->BorderTable($bandera); /*para activar color de la fila*/

            $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
            $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
            //$pdf->SetFont('arial', '', 7);

            $pdf->SetLeftMargin(0);
            $pdf->Row($datosarray, 3.5);


            // INICIO WATERMARCK
            $pdf->printWATERMARCK($_CONFIGCELDA);
            // FIN WATERMARCK

            $bandera = !$bandera;

            $keyDATOEXCEL++;
        }


        if ($pdf->PageNo() == 1) {
            $LimitPagePrintFila = 6 - count($HTML_DATOS);

            for ($numero = 0; $numero <= $LimitPagePrintFila; $numero++) {
                unset($datosarray);
                foreach ($HTML_CAMPOS as $key2 => $row2) {
                    $datosarray[] = "";
                }

                //$pdf->SetFillColor(240, 240, 240); /*Fondo gris de celda*/
                //$pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
                //$pdf->SetTextColor(0, 0, 0); /*Letra color blanco*/

                //$pdf->styleRect($bandera); /*margin de celdas*/
                //$pdf->BorderTable($bandera); /*para activar color de la fila*/

                $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
                $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
                //$pdf->SetFont('arial', 'B', 7);
                $pdf->printColor('negro', 4, '#ffffff', '#000000');
                $pdf->SetX($x);
                $pdf->SetLeftMargin(0);
                $pdf->Row($datosarray, 3.5);

                //$bandera = !$bandera;
            }
        }


        $yUltimoProducto = $pdf->GetY() + 5;

        $es_nota_o_factura = false;

        if ($dato['cotizacion']) {
            $es_nota_o_factura = false;
        }

        if ($dato['interno']) {
            $es_nota_o_factura = true;
        }

        if ($dato['nota_sencilla']) {
            $es_nota_o_factura = true;
        }

        if ($dato['factura']) {
            $es_nota_o_factura = true;
        }

        $anticipo = $dato['anticipo'];

        $total = 0;
        $iva = 16;

        foreach ($HTML_DATOS as $key => $row) {
            $total += $row['venta_precio_normal'];
        }

        //dd($HTML_DATOS);

        $descuento = $dato['no_desglosar_iva'] ? $dato['descuento'] * 1.16 : $dato['descuento'];
        $subtotal = $dato['no_desglosar_iva'] ? $total : ($total / (($iva / 100) + 1));
        $iva_total = $total - $subtotal;
        $total = $dato['total'];
        $total_pagado = $dato['total_pagado'];

        /*foreach ($HTML_DATOS as $key => $row) {
            $total += $row['venta_precio_normal'];
        }

        $subtotal = ($total / (($iva / 100) + 1));
        $iva_total = $total - $subtotal;

        $rowDesglose[] = array(
            0 => "SUB. TOTAL:",
            1 => "$" . number_format($subtotal, 2)
        );

        $rowDesglose[] = array(
            0 => "I.V.A. " . $iva . "%:",
            1 => "$" . number_format($iva_total, 2)
        );

        $rowDesglose[] = array(
            0 => "TOTAL:",
            1 => "$" . number_format($total, 2)
        );


        if ($es_nota_o_factura) {
            $rowDesglose[] = array(
                0 => "",
                1 => ""
            );
            $rowDesglose[] = array(
                0 => "ANTICIPO:",
                1 => "$" . number_format($anticipo, 2)
            );
            $rowDesglose[] = array(
                0 => "POR PAGAR:",
                1 => "$" . number_format($total - $anticipo, 2)
            );
        }*/

        if ($descuento > 0) {
            $rowDesglose[] = array(
                0 => $dato["no_desglosar_iva"] ? "SUB. TOTAL:":"SUB. TOTAL (SIN DESC.):",
                1 => "$" . number_format($subtotal, 2)
            );

            $rowDesglose[] = array(
                0 => "DESCUENTO:",
                1 => "$" . number_format($descuento, 2)
            );
        }

        if (!$dato["no_desglosar_iva"]) {
            $rowDesglose[] = array(
                0 => "SUB. TOTAL:",
                1 => "$" . number_format($subtotal - $descuento, 2)
            );

            $rowDesglose[] = array(
                0 => "I.V.A. " . $iva . "%:",
                1 => "$" . number_format($iva_total, 2)
            );
        }

        $rowDesglose[] = array(
            0 => "TOTAL:",
            1 => "$" . number_format($dato["no_desglosar_iva"] ? $subtotal - $descuento : $total, 2)
        );


        if ($es_nota_o_factura) {
            $rowDesglose[] = array(
                0 => "",
                1 => "",
            );
            $rowDesglose[] = array(
                0 => "ANTICIPO:",
                1 => "$" . number_format($anticipo, 2)
            );
            $rowDesglose[] = array(
                0 => "POR PAGAR:",
                1 => "$" . number_format($total - $total_pagado, 2)
            );
        }


        /*
         * INICIO DESGLOSE DE TOTALES
         * */
        $pdf->SetY($pdf->GetY() - 10);

        $wTotal = array_reverse($tamanio)[0] + array_reverse($tamanio)[1] + array_reverse($tamanio)[2] + array_reverse($tamanio)[3] + array_reverse($tamanio)[4];

        $y = $pdf->GetY();
        $pdf->SetXY(0, $y + 8);
        $pdf->SetFont('arial', 'B', 5);
        $TXT = "¡DISEÑAMOS AL GUSTO DE NUESTROS CLIENTES!";
        $pdf->MultiCell(35, 2, $pdf->DecodeText($TXT), 0, 'C', false);

        $pdf->SetY($yUltimoProducto - 10);
        foreach ($rowDesglose as $key => $desglose) {
            //$pdf->SetFillColor(240, 240, 240); /*Fondo gris de celda*/
            //$pdf->SetDrawColor(230, 230, 230); /*Color margin de celdas*/
            //$pdf->SetTextColor(0, 0, 0); /*Letra color blanco*/

            $pdf->styleRect(0); /*margin de celdas*/
            $pdf->BorderTable(1); /*para activar color de la fila*/

            //$pdf->SetWidths($tamanio); /*tamaño de celdas array*/
            $pdf->SetAligns('L'); /*alineacion de texto en celda array*/
            $pdf->SetFont('arial', 'B', 6);

            $pdf->SetX($x + 36);

            $pdf->SetLeftMargin(0);
            $pdf->Row($desglose, 3.5);
        }

        /*
         * INICIO DESGLOSE DE TOTALES
         * */


        /*
         * INICIO TEXTOS
         * */

        $pdf->SetY($pdf->GetY() + 2);


        $xInitExtra = 2;

        $y = $pdf->GetY();
        $pdf->SetXY($xInitExtra, $y);
        $pdf->printColor(null, 6, '#ffffff', '#000000');
        $TXT = "1.- Todo trabajo requiere un 50 % de anticipo";
        $pdf->MultiCell($wTotal, 3, $pdf->DecodeText($TXT), 0, 'L', false);

        $y = $pdf->GetY();
        $pdf->SetXY($xInitExtra, $y);
        $TXT = "2.- Precios sujetos a cambio sin previo aviso";
        $pdf->MultiCell($wTotal, 3, $pdf->DecodeText($TXT), 0, 'L', false);


        /*
         * FIN TEXTOS
         * */

        $xInitExtra = $x + (array_sum($tamanio) - $wTotal);
        /*
         * INICIO PAGO EFECTIVO O TRANSFERENCIA
         * */

        $hFill = 3;
        $wFill = ($wTotal - 2) - $hFill;
        $pdf->SetY($pdf->GetY() - 4);


        $pdf->Ln(3);

        if (count($dato['formas_de_pago']) > 0) {
            $y = $pdf->GetY() + 2;
            $pdf->SetXY($xInitExtra + 1, $y);

            //$pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            //$pdf->SetFillColor(255, 255, 255);
            //$pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 7);
            $pdf->Cell($wFill + 2, 3, "FORMAS DE PAGO:", 0, 0, 'C', false);

        }

        foreach ($dato['formas_de_pago'] as $key => $row) {

            $y = $pdf->GetY() + 4;
            $pdf->SetXY($xInitExtra, $y);

            $checked = '4';
            $label = strtoupper(utf8_decode($row['forma_pago']));
            $monto = strtoupper(utf8_decode($row['total']));

            //$pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            //$pdf->SetFillColor(255, 255, 255);
            //$pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell($wFill - 15, $hFill, $label, 0, 0, 'L', false);

            //$pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            //$pdf->SetFillColor(255, 255, 255);
            //$pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell(18, $hFill, $monto, 0, 0, 'R', false);

            //$pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
            //$pdf->SetFillColor(220, 220, 220);
            //$pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('ZapfDingbats', '', 6);
            $pdf->Cell($hFill, $hFill, $checked, 1, 0, 'R', true);

        }

        /*
         * Para regresar a usar la FUENTE arial
         * */
        $pdf->Ln(10);

        $pdf->SetFont('Arial', '', 8);

        $ultimoFormasDePago = $pdf->GetY() + 0;

        /*
         * FIN PAGO EFECTIVO O TRANSFERENCIA
         * */

        // INICIO WATERMARCK
        $pdf->printWATERMARCK($_CONFIGCELDA);
        // FIN WATERMARCK

    }

    /*
     * GENERAR TICKET DE PAGO
     * */

    public static function OBSERVACIONESTICKET($pdf, &$x, $TPapelH, $yUltimo, $dato, &$yUltimoObservaciones)
    {
        $pdf->Ln();

        $yInit = $yUltimo - 5;
        $xInit = $pdf->GetX() + 2;
        $wTotal = $TPapelH - (($TPapelH * 30) / 100);

        $observacion = $dato['observaciones'] . '
        ';

        $pdf->SetDrawColorHex("#ffffff");
        //$pdf->SetFillColorHex("#F2F2F2");


        $pdf->SetXY($xInit, $yInit);
        //$pdf->SetTextColorHex("#666666");
        $pdf->SetFont('Arial', '', 7);
        $pdf->Cell($wTotal, 5 + 3, "OBSERVACIONES:", "LTR", 0, 'L', true);


        $pdf->SetXY($xInit, $pdf->GetY() + 6);
        //$pdf->SetTextColorHex("#333333");
        $pdf->SetFont('Arial', '', 7);
        $pdf->MultiCell($wTotal, 4, $pdf->DecodeText($observacion), "LBR", 'L', true);

        $x = $xInit + $wTotal; // retoranara la cordaneada en x en la que se quedo para continuar apartir de ahi con la impresion de la tabla de productoss

        $yUltimoObservaciones = $pdf->GetY() + 5;

        $pdf->Ln();

        //$pdf->SetDrawColor(0, 0, 0); /*Color margin de celdas*/
    }

    public static function TEXTO_DISCLAIMER_TICKET($pdf, $TPapelH, $ver_fimmas)
    {

        if ($ver_fimmas) {
            $limite = 5;
        } else {
            $limite = 229;
        }

        if ($pdf->GetY() <= $limite) {
            $pdf->SetY($limite);
        }

        /*  if ($pdf->GetY() > $limite) {
              $pdf->AddPage();
          }*/

        $TXT01 = "El cliente manifiesta bajo protesta de decir verdad que la denominación, elementos, diseño, marca y/o logo del cual solicita el trabajo y/o servicio son de su propiedad y/o autoría, se encuentra legalmente autorizado o no tiene restricción legal para emplearlos, por lo que no existe violación alguna a Derechos de autor, ni a la Ley de Propiedad Industrial ni a su respectivo reglamento, por lo que exime a la empresa Mark Desing de toda responsabilidad por el uso o reproducción de los mismos en base al servicio o trabajo que ampara esta orden, siendo completa responsabilidad del cliente el uso y/o reproducción que se solicita.";
        $TXT02 = "Mark Desing no reconoce autoría ni derecho alguno al cliente respecto a la denominación, elementos, diseño, marca y/o logo del cual solicita el servicio, limitándose a realizar el trabajo que ampara esta orden en la forma y términos solicitados por el cliente, sin que Mark Desing haga uso alguno de ellos.";
        $TXT03 = "Mark Desing se reserva el derecho de no realizar o suspender cualquier trabajo en cuanto se percate de la violación de derechos de autor o de propiedad industrial, y dar aviso a la autoridad competente por las infracciones cometidas.";

        $borde_boolena = false;
        $bg_boolean = false;

        $pdf->SetX(2);
        $pdf->printColor(null, 7, '#ffffff', '#000000');
        $pdf->MultiCell($TPapelH, 3, $pdf->DecodeText($TXT01), $borde_boolena, 'J', $bg_boolean);

        $pdf->SetX(2);
        $pdf->printColor(null, 7, '#ffffff', '#000000');
        $pdf->MultiCell($TPapelH, 3, $pdf->DecodeText($TXT02), $borde_boolena, 'J', $bg_boolean);

        $pdf->SetX(2);
        $pdf->printColor(null, 7, '#ffffff', '#000000');
        $pdf->MultiCell($TPapelH, 3, $pdf->DecodeText($TXT03), $borde_boolena, 'J', $bg_boolean);

        $pdf->Ln();
    }

    /*
     * GENERAR TICKET DE PAGO
     * */

    public static function GenerateTICKETENTREGA($dato, $TAM_H_mm = 85, $TAM_W_mm = 58)
    {

        foreach ($dato['VENTA']['DETALLE'] as $key => $row) {
            $cantidadchar = strlen($row['CONCEPTO_DESCRIPCION']);
            $cantidadchar = number_format($cantidadchar / 30);
            if ($cantidadchar == 0) {
                $cantidadchar = 1;
            }
            $TAM_H_mm = $TAM_H_mm + ($cantidadchar * 2.5);
        }

        define("FONT_TICKET_B", "helvetica");
        define("FONT_TICKET_R", "helvetica");

        $SIZEFONTDETALLE = 6.5;
        $LIMITACION = 0;
        $TPapelTiket = array($TAM_W_mm, $TAM_H_mm);

        $pdf = new PDF('P', 'mm', $TPapelTiket);
        $pdf->AddPage();


        #Establecemos los márgenes izquierda, arriba y derecha:
        $pdf->SetMargins(2, 3, 2);
        #Establecemos el margen inferior:
        $pdf->SetAutoPageBreak(true, 3);


        // INICIO LOGO
        $cw = 2;
        $ch = 3;
        $wi = 15;
        $hi = 9;
        if ($dato['INFO']['EMPRESA_LOGO'] != "") {
            if (file_exists(env('DOC_IMAGE_TO_PDF') . $dato['INFO']['EMPRESA_LOGO'])) {
                $pdf->Image(env('DOC_IMAGE_TO_PDF') . $dato['INFO']['EMPRESA_LOGO'], $cw, $ch, $wi, $hi);
            }
        }
        // FIN LOGO

        // INICIO VARIABLES
        $x = 2;
        $y = 3;
        $texX = 54;
        $texY = 2.2;
        $pdf->SetXY($x, $y);
        // FIN VARIABLES

        // INICIO DATOS DERECHA

        if ($dato['INFO']['EMPRESA_RAZON_SOCIAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 15, $y);
            $pdf->printColorTicket('negro', 7, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY + 1, $pdf->DecodeText($dato['INFO']['EMPRESA_RAZON_SOCIAL']), $LIMITACION, 'L', false);
        }

        // $pdf->Cell(0,2, "Your Name", '1', 2, 'L', false); //Name

        if ($dato['INFO']['EMPRESA_SUCURSAL']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 15, $y);
            $pdf->printColorTicket('negro', 6, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY + 1, $pdf->DecodeText($dato['INFO']['EMPRESA_SUCURSAL']), $LIMITACION, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_RFC']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 15, $y);
            $pdf->printColorTicket('negro', 5, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY + 1, $pdf->DecodeText($dato['INFO']['EMPRESA_RFC']), $LIMITACION, 2, 'L', false);
        }

        if ($dato['INFO']['EMPRESA_DIRECCION']) {
            $y = $pdf->GetY();
            $pdf->SetXY($x + 10, $y);
            $pdf->printColorTicket('negro', 5, '#ffffff');
            $pdf->MultiCell($texX - 15, $texY, $pdf->DecodeText($dato['INFO']['EMPRESA_DIRECCION']), $LIMITACION, 'C', false);
            $pdf->Ln();
        }

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "- * - * - * - * - * - * - * - * - * - * - * - * - * - * - * - * -", $LIMITACION, 'C', false);

        // FIN DATOS DERECHA

        // INICIO DATOS CABECERA
        $y = $pdf->GetY() + 3;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "Folio: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['FOLIO']), $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "TICKET: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['FOLIO_TICKET']), $LIMITACION, 'C', false);


//        $y = $pdf->GetY() + 3;
//        $pdf->SetXY($x, $y);
//        $pdf->printColorTicket('negro', 5, '#ffffff');
//        $pdf->MultiCell($texX, $texY, "Fecha: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['FECHA_REGISTRO']), $LIMITACION, 'C', false);

        $y = $pdf->GetY() + 3;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "Cliente: " . $pdf->DecodeText($dato['VENTA']['CABECERA']['NOMBRE_COMERCIAL']), $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, $pdf->DecodeText($dato['VENTA']['CABECERA']['LABEL']), $LIMITACION, 'C', false);

        $pdf->Ln();

        // FIN DATOS CABECERA
        // INICIO HEADER TABLE TICKET
        $filasCabeceras = array(
            utf8_decode('Concepto/descripción'),
            utf8_decode('Cantidad')
        );

        $tamanio = array(35, 19);
        $aling = array('L', 'R');


        $pdf->styleRect($LIMITACION); /*margin de celdas*/
        $pdf->BorderTable($LIMITACION); /*para activar color de la fila*/

        $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
        $pdf->SetAligns($aling); /*alineacion de texto en celda array*/

        $pdf->SetFont(FONT_TICKET_R, '', $SIZEFONTDETALLE - 1);

        $pdf->Row($filasCabeceras);
        // FIN HEADER TABLE TICKET

//        // INICIO HEADER TABLE TICKET
        foreach ($dato['VENTA']['DETALLE'] as $key => $row) {

            $filasCabeceras = array(
                utf8_decode($row['CONCEPTO_DESCRIPCION']),
                $row['CANTIDAD']
            );

            $aling = array('L', 'R');

            $pdf->styleRect($LIMITACION); /*margin de celdas*/
            $pdf->BorderTable($LIMITACION); /*para activar color de la fila*/

            $pdf->SetWidths($tamanio); /*tamaño de celdas array*/
            $pdf->SetAligns($aling); /*alineacion de texto en celda array*/
            $pdf->SetFont(FONT_TICKET_R, '', $SIZEFONTDETALLE - 1);

            $pdf->Row($filasCabeceras, 2.5);
        }

        $y = $pdf->GetY() + 3;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, utf8_decode("Visítanos en: " . $dato['INFO']['EMPRESA_PAGINA_WEB']), $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "E-Mail: " . $dato['INFO']['EMPRESA_CORREO_ELECTRONICO'], $LIMITACION, 'C', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, $dato['INFO']['EMPRESA_TELEFONO'], $LIMITACION, 'C', false);

        // FIN DATOS FOOTHER TICKETS

        // INICIO ETIQUETA FOOTER
        $y = $pdf->GetY() + 5;
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, utf8_decode("Fecha de impresión " . date("Y-m-d H:i:s")), $LIMITACION, 'R', false);

        $y = $pdf->GetY();
        $pdf->SetXY($x, $y);
        $pdf->printColorTicket('negro', 5, '#ffffff');
        $pdf->MultiCell($texX, $texY, "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - O R I G I N A L", $LIMITACION, 'C', false);
        // FIN ETIQUETA FOOTER

        switch ($dato['SETTINGS']['action']) {
            case 'DESCARGAR':
                $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                $pdf->Output('D', utf8_decode($filename));
                break;
            case 'VER':
                $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                $pdf->Output('I', utf8_decode($filename));
                break;
            case 'IMPRIMIR':
                $filename = $dato['SETTINGS']['fileName'] . "-" . date("d-m-Y His") . ".pdf";
                $pdf->AutoPrint(true);
                $pdf->Output('I', utf8_decode($filename));
                break;
        }
        exit();
    }

}
