<?php

namespace App\Http\Controllers\SIS;

use App\Http\Controllers\Controller;
use App\Http\Dao\Implement\IDAOAlumnos;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class AlumnosController extends Controller
{
    protected $IDAOAlumnos = null;

    /**
     * OrientacionController constructor.
     * @param null $IDAOAlumnos
     */
    public function __construct(IDAOAlumnos $IDAOAlumnos)
    {
        $this->IDAOAlumnos = $IDAOAlumnos;
    }

    public function listar_alumnos(Request $request)
    {

        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            DB::beginTransaction();

            try {
                $filtro = (object)($data_request['data']['filtro'] ?? array());
                $paginacion = (object)($data_request['data']['paginacion'] ?? array());

                $this->IDAOAlumnos->setFiltroNombre($filtro->nombre ?? null);
                $this->IDAOAlumnos->setFiltroCorreoElectronico($filtro->correo_electronico ?? null);
                $this->IDAOAlumnos->setFiltroTelefono($filtro->telefono ?? null);
                $this->IDAOAlumnos->setFiltroActivo(($filtro->activo === 1 || $filtro->activo === 0) ? (int)$filtro->activo : null);

                $this->IDAOAlumnos->setPage($paginacion->page ?? 0);
                $this->IDAOAlumnos->setLimit($paginacion->limit ?? 5);

                $data_db = $this->IDAOAlumnos->all($paginacion);

                if ($data_db == null) {
                    $flag_request = true;
                    $status = 400;
                    $message = "No se encontraron datos.";
                    $data = array();
                    DB::rollback();
                } else {
                    $flag_request = true;
                    $status = 200;
                    $message = "Datos encontrados.";
                    $data = $data_db;
                    DB::commit();
                }

                $response = [
                    "success" => $flag_request,
                    "status" => $status,
                    "message" => $message,
                    "data" => $data,
                    "paginacion" => $paginacion,
                ];

            } catch (Exception $e) {
                DB::rollback();
                $log = $this->ErrorTransaction($e, $request);
                return $log;
            }
        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function agregar_alumnos(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_alumno' => '',
                'nombre' => 'required',
                'apellido_paterno' => 'required',
                'apellido_materno' => '',
                'telefono' => 'required',
                'numero_emergencia' => 'required',
                'correo_electronico' => 'required|email',
                'tipo_sangre' => '',
                'fecha_nacimiento' => 'required',
                'lugar_nacimiento' => '',
                'codigo_postal' => '',
                'direccion' => 'required',
                'alergia_lesion_otro' => '',
                'tutor' => 'required',
                'fecha_ingreso' => 'required',
                'id_cat_modalidad' => 'required',
                'id_cat_nivel' => 'required',
                'id_cat_horario' => 'required',
                'id_cat_tipo_inscripcion' => 'required',
                'costo' => 'required',
                'fecha_inicio_pago' => 'required',
                'fecha_fin_pago' => 'required',
                'id_usuario' => 'required',
                'certificado_medico' => 'required',
                'responsiva' => 'required',
                'edad' => '',
                'notas' => '',
                'foto' => 'required',
                'formato' => 'required',
                'activo' => 'required',
            ],
            [
                'foto.required' => 'Selecciona la imagen para foto de perfil del alumno',
                'formato.required' => 'No se obtuvo el formato del archivo',
            ]
        );

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $foto = $data_request['data']['foto'];
                    $formato = $data_request['data']['formato'];

                      $archivo = array(
                          "success" => false,
                          "ruta" => NULL
                      );

                    if (isset($foto) && isset($formato)) {
                        if (!empty($foto) && !empty($formato)) {
                            $nombre_archivo = 'foto_perfil_' . md5($Usr->id_usuario) . $this->DATETIMEUNIX();
                            $archivo = $this->Base64ToFile($foto, env('URL_ARCHIVO_PERFIL'), $nombre_archivo, $formato);
                        }
                    }

                    if ($archivo['success'] === true) {
                        $this->IDAOAlumnos->setFoto($archivo['ruta']);
                    } else {
                        $this->IDAOAlumnos->setFoto(null);
                    }

                    $this->IDAOAlumnos->setIdAlumno(null);
                    $this->IDAOAlumnos->setNombre($data_request['data']["nombre"]);
                    $this->IDAOAlumnos->setApellidoPaterno($data_request['data']["apellido_paterno"]);
                    $this->IDAOAlumnos->setApellidoMaterno($data_request['data']["apellido_materno"]);
                    $this->IDAOAlumnos->setTelefono($data_request['data']["telefono"]);
                    $this->IDAOAlumnos->setNumeroEmergencia($data_request['data']["numero_emergencia"]);
                    $this->IDAOAlumnos->setCorreoElectronico($data_request['data']["correo_electronico"]);
                    $this->IDAOAlumnos->setTipoSangre($data_request['data']["tipo_sangre"]);
                    $this->IDAOAlumnos->setFechaNacimiento($data_request['data']["fecha_nacimiento"]);
                    $this->IDAOAlumnos->setLugarNacimiento($data_request['data']["lugar_nacimiento"]);
                    $this->IDAOAlumnos->setCodigoPostal($data_request['data']["codigo_postal"]);
                    $this->IDAOAlumnos->setDireccion($data_request['data']["direccion"]);
                    $this->IDAOAlumnos->setAlergiaLesionOtro($data_request['data']["alergia_lesion_otro"]);
                    $this->IDAOAlumnos->setTutor($data_request['data']["tutor"]);
                    $this->IDAOAlumnos->setFechaIngreso($data_request['data']["fecha_ingreso"]);
                    $this->IDAOAlumnos->setIdCatModalidad($data_request['data']["id_cat_modalidad"]);
                    $this->IDAOAlumnos->setIdCatNivel($data_request['data']["id_cat_nivel"]);
                    $this->IDAOAlumnos->setIdCatHorario($data_request['data']["id_cat_horario"]);
                    $this->IDAOAlumnos->setIdCatTipoInscripcion($data_request['data']["id_cat_tipo_inscripcion"]);
                    $this->IDAOAlumnos->setCosto($data_request['data']["costo"]);
                    $this->IDAOAlumnos->setFechaInicioPago($data_request['data']["fecha_inicio_pago"]);
                    $this->IDAOAlumnos->setFechaFinPago($data_request['data']["fecha_fin_pago"]);
                    $this->IDAOAlumnos->setIdUsuario($data_request['data']["id_usuario"]);
                    $this->IDAOAlumnos->setCertificadoMedico($data_request['data']["certificado_medico"]);
                    $this->IDAOAlumnos->setResponsiva($data_request['data']["responsiva"]);
                    $this->IDAOAlumnos->setNotas($data_request['data']["notas"]);
                    $this->IDAOAlumnos->setEdad($this->obtener_edad_segun_fecha($data_request['data']["fecha_nacimiento"]));
                    $this->IDAOAlumnos->setActivo($data_request['data']["activo"]);

                    $insert_data = $this->IDAOAlumnos->create();

                    if ($insert_data > 0) {
                        $flag_request = true;
                        $status = 200;
                        $message = "Datos guardados con éxito.";
                        $data = $insert_data;
                        DB::commit();
                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "Error al guardar los datos.";
                        $data = array();
                        DB::rollback();
                    }

                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function modificar_alumnos(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_alumno' => 'required',
                'nombre' => 'required',
                'apellido_paterno' => 'required',
                'apellido_materno' => '',
                'telefono' => 'required',
                'numero_emergencia' => 'required',
                'correo_electronico' => 'required|email',
                'tipo_sangre' => '',
                'fecha_nacimiento' => 'required',
                'lugar_nacimiento' => '',
                'codigo_postal' => '',
                'direccion' => 'required',
                'alergia_lesion_otro' => '',
                'tutor' => 'required',
                'fecha_ingreso' => 'required',
                'id_cat_modalidad' => 'required',
                'id_cat_nivel' => 'required',
                'id_cat_horario' => 'required',
                'id_cat_tipo_inscripcion' => 'required',
                'costo' => 'required',
                'fecha_inicio_pago' => 'required',
                'fecha_fin_pago' => 'required',
                'id_usuario' => 'required',
                'certificado_medico' => 'required',
                'responsiva' => 'required',
                'edad' => '',
                'notas' => '',
                'foto' => 'required',
                'activo' => 'required',
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $this->IDAOAlumnos->setIdAlumno($data_request['data']["id_alumno"]);
                    $existe_registro = $this->IDAOAlumnos->show();

                    if ($existe_registro) {
                        $foto = $data_request['data']['foto'];
                        $formato = $data_request['data']['formato'];

                        $archivo = array(
                            "success" => false,
                            "ruta" => NULL
                        );

                        if (isset($foto) && isset($formato) && $foto != $existe_registro->foto) {
                            if (!empty($foto) && !empty($formato)) {
                                $nombre_archivo = 'foto_perfil_' . md5($Usr->id_usuario) . $this->DATETIMEUNIX();
                                $archivo = $this->Base64ToFile($foto, env('URL_ARCHIVO_PERFIL'), $nombre_archivo, $formato);
                            }
                        }

                        if ($archivo['success'] === true) {
                            $this->IDAOAlumnos->setFoto($archivo['ruta']);
                        } else {
                            $this->IDAOAlumnos->setFoto($existe_registro->foto);
                        }

                        $this->IDAOAlumnos->setIdAlumno($data_request['data']["id_alumno"]);
                        $this->IDAOAlumnos->setNombre($data_request['data']["nombre"]);
                        $this->IDAOAlumnos->setApellidoPaterno($data_request['data']["apellido_paterno"]);
                        $this->IDAOAlumnos->setApellidoMaterno($data_request['data']["apellido_materno"]);
                        $this->IDAOAlumnos->setTelefono($data_request['data']["telefono"]);
                        $this->IDAOAlumnos->setNumeroEmergencia($data_request['data']["numero_emergencia"]);
                        $this->IDAOAlumnos->setCorreoElectronico($data_request['data']["correo_electronico"]);
                        $this->IDAOAlumnos->setTipoSangre($data_request['data']["tipo_sangre"]);
                        $this->IDAOAlumnos->setFechaNacimiento($data_request['data']["fecha_nacimiento"]);
                        $this->IDAOAlumnos->setLugarNacimiento($data_request['data']["lugar_nacimiento"]);
                        $this->IDAOAlumnos->setCodigoPostal($data_request['data']["codigo_postal"]);
                        $this->IDAOAlumnos->setDireccion($data_request['data']["direccion"]);
                        $this->IDAOAlumnos->setAlergiaLesionOtro($data_request['data']["alergia_lesion_otro"]);
                        $this->IDAOAlumnos->setTutor($data_request['data']["tutor"]);
                        $this->IDAOAlumnos->setFechaIngreso($data_request['data']["fecha_ingreso"]);
                        $this->IDAOAlumnos->setIdCatModalidad($data_request['data']["id_cat_modalidad"]);
                        $this->IDAOAlumnos->setIdCatNivel($data_request['data']["id_cat_nivel"]);
                        $this->IDAOAlumnos->setIdCatHorario($data_request['data']["id_cat_horario"]);
                        $this->IDAOAlumnos->setIdCatTipoInscripcion($data_request['data']["id_cat_tipo_inscripcion"]);
                        $this->IDAOAlumnos->setCosto($data_request['data']["costo"]);
                        $this->IDAOAlumnos->setFechaInicioPago($data_request['data']["fecha_inicio_pago"]);
                        $this->IDAOAlumnos->setFechaFinPago($data_request['data']["fecha_fin_pago"]);
                        $this->IDAOAlumnos->setIdUsuario($data_request['data']["id_usuario"]);
                        $this->IDAOAlumnos->setCertificadoMedico($data_request['data']["certificado_medico"]);
                        $this->IDAOAlumnos->setResponsiva($data_request['data']["responsiva"]);
                        $this->IDAOAlumnos->setNotas($data_request['data']["notas"]);
                        $this->IDAOAlumnos->setEdad($this->obtener_edad_segun_fecha($data_request['data']["fecha_nacimiento"]));
                        $this->IDAOAlumnos->setActivo($data_request['data']["activo"]);

                        $update_data = $this->IDAOAlumnos->update();

                        if ($update_data > 0) {
                            $flag_request = true;
                            $status = 200;
                            $message = "Datos actualizados con éxito.";
                            $data = array();
                            DB::commit();
                        } else {
                            $flag_request = false;
                            $status = 400;
                            $message = "Error al actualizar los datos.";
                            $data = array();
                            DB::rollback();
                        }
                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "No existe este registro.";
                        $data = array();
                        DB::rollback();
                    }

                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function eliminar_alumnos(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_alumno' => 'required'
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $this->IDAOAlumnos->setIdAlumno($data_request['data']["id_alumno"]);
                    $existe_registro = $this->IDAOAlumnos->show();

                    if ($existe_registro) {

                        $this->IDAOAlumnos->setIdAlumno($data_request['data']["id_alumno"]);
                        $delete_data = $this->IDAOAlumnos->delete();

                        if ($delete_data > 0) {
                            $flag_request = true;
                            $status = 200;
                            $message = "Datos eliminados con éxito.";
                            $data = array();
                            DB::commit();
                        } else {
                            $flag_request = false;
                            $status = 400;
                            $message = "Error al eliminar los datos.";
                            $data = array();
                            DB::rollback();
                        }
                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "No existe el registro que intentas eliminar.";
                        $data = array();
                        DB::rollback();
                    }

                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

}
