<?php

namespace App\Http\Controllers\SIS;

use App\Http\Controllers\Controller;
use App\Http\Controllers\SIS\PusherController;
use App\Http\Dao\Implement\IDAOComentario;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ComentarioController extends Controller
{
    protected $IDAOComentario = null;

    /**
     * ComentarioController constructor.
     * @param null $IDAOComentario
     */
    public function __construct(IDAOComentario $IDAOComentario)
    {
        $this->IDAOComentario = $IDAOComentario;
    }

    public function listar_comentario(Request $request)
    {

        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            DB::beginTransaction();

            try {

                $data_db = $this->IDAOComentario->all();

                if ($data_db == null) {
                    $flag_request = true;
                    $status = 400;
                    $message = "No se encontraron datos.";
                    $data = array();
                    DB::rollback();
                } else {
                    $flag_request = true;
                    $status = 200;
                    $message = "Datos encontrados.";
                    $data = $data_db;
                    DB::commit();
                }

                $response = [
                    "success" => $flag_request,
                    "status" => $status,
                    "message" => $message,
                    "data" => $data
                ];

            } catch (Exception $e) {
                DB::rollback();
                $log = $this->ErrorTransaction($e, $request);
                return $log;
            }
        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function agregar_comentario(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_ruta' => 'required',
                'comentario' => 'required',
                'activo' => 'required',
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $this->IDAOComentario->setIdRuta($data_request['data']["id_ruta"]);
                    $this->IDAOComentario->setIdUsuario($Usr->id_usuario);
                    $this->IDAOComentario->setComentario($data_request['data']["comentario"]);
                    $this->IDAOComentario->setActivo($data_request['data']["activo"]);

                    $insert_data = $this->IDAOComentario->create();

                    if ($insert_data > 0) {
                        $flag_request = true;
                        $status = 200;
                        $message = "Datos guardados con éxito.";
                        $data = $insert_data;
                        DB::commit();

                        $pusher = new PusherController();
                        $pusher->PusherUpdateViewMonitor();
                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "Error al guardar los datos.";
                        $data = array();
                        DB::rollback();
                    }

                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function modificar_comentario(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_comentario' => 'required',
                'id_ruta' => 'required',
                'comentario' => 'required',
                'activo' => 'required',
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $this->IDAOComentario->setIdComentario($data_request['data']["id_comentario"]);
                    $existe_registro = $this->IDAOComentario->show();

                    if ($existe_registro) {

                        $this->IDAOComentario->setIdRuta($data_request['data']["id_ruta"]);
                        $this->IDAOComentario->setIdUsuario($Usr->id_usuario);
                        $this->IDAOComentario->setComentario($data_request['data']["comentario"]);
                        $this->IDAOComentario->setActivo($data_request['data']["activo"]);

                        $update_data = $this->IDAOComentario->update();

                        if ($update_data > 0) {
                            $flag_request = true;
                            $status = 200;
                            $message = "Datos actualizados con éxito.";
                            $data = array();
                            DB::commit();

                            $pusher = new PusherController();
                            $pusher->PusherUpdateViewMonitor();
                        } else {
                            $flag_request = false;
                            $status = 400;
                            $message = "Error al actualizar los datos.";
                            $data = array();
                            DB::rollback();
                        }
                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "No existe este registro.";
                        $data = array();
                        DB::rollback();
                    }

                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function eliminar_comentario(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_comentario' => 'required'
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $this->IDAOComentario->setIdComentario($data_request['data']["id_comentario"]);
                    $existe_registro = $this->IDAOComentario->show();

                    if ($existe_registro) {

                        $this->IDAOComentario->setIdComentario($data_request['data']["id_comentario"]);
                        $delete_data = $this->IDAOComentario->delete();

                        if ($delete_data > 0) {
                            $flag_request = true;
                            $status = 200;
                            $message = "Datos eliminados con éxito.";
                            $data = array();
                            DB::commit();

                            $pusher = new PusherController();
                            $pusher->PusherUpdateViewMonitor();
                        } else {
                            $flag_request = false;
                            $status = 400;
                            $message = "Error al eliminar los datos.";
                            $data = array();
                            DB::rollback();
                        }
                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "No existe el registro que intentas eliminar.";
                        $data = array();
                        DB::rollback();
                    }

                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

}
