<?php

namespace App\Http\Controllers\SIS;

use App\Http\Controllers\Controller;
use App\Http\Dao\Implement\IDAOExpediente;
use App\Http\Dao\Implement\IDAOExpedienteArchivo;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ExpedienteController extends Controller
{
    protected $IDAOExpediente = null;
    protected $IDAOExpedienteArchivo = null;

    /**
     * ZonaController constructor.
     * @param null $IDAOExpediente
     */

    public function __construct(IDAOExpediente $IDAOExpediente, IDAOExpedienteArchivo $IDAOExpedienteArchivo)
    {
        $this->IDAOExpediente = $IDAOExpediente;
        $this->IDAOExpedienteArchivo = $IDAOExpedienteArchivo;
    }

    public function listar_expediente(Request $request)
    {

        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            DB::beginTransaction();

            try {
                $filtro = (object)($data_request['data']['filtro'] ?? array());
                $paginacion = (object)($data_request['data']['paginacion'] ?? array());

                $this->IDAOExpediente->setFiltroIdExpediente($filtro->id_expediente ?? null);
                $this->IDAOExpediente->setFiltroNombre($filtro->nombre ?? null);
                $this->IDAOExpediente->setFiltroCurp($filtro->curp ?? null);
                $this->IDAOExpediente->setFiltroRfc($filtro->rfc ?? null);
                $this->IDAOExpediente->setFiltroIdCatIdentificacion($filtro->id_cat_identificacion ?? null);
                $this->IDAOExpediente->setFiltroFechaIngreso($filtro->fecha_ingreso ?? null);
                $this->IDAOExpediente->setFiltroActivo(($filtro->activo === 1 || $filtro->activo === 0) ? (int)$filtro->activo : null);

                $this->IDAOExpediente->setPage($paginacion->page ?? 0);
                $this->IDAOExpediente->setLimit($paginacion->limit ?? 5);

                $data_db = $this->IDAOExpediente->all($paginacion);

                if ($data_db == null) {
                    $flag_request = true;
                    $status = 400;
                    $message = "No se encontraron datos.";
                    $data = array();
                    DB::rollback();
                } else {
                    $flag_request = true;
                    $status = 200;
                    $message = "Datos encontrados.";
                    $data = $data_db;
                    DB::commit();
                }

                $response = [
                    "success" => $flag_request,
                    "status" => $status,
                    "message" => $message,
                    "data" => $data,
                    "paginacion" => $paginacion,
                ];

            } catch (Exception $e) {
                DB::rollback();
                $log = $this->ErrorTransaction($e, $request);
                return $log;
            }
        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function agregar_expediente(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_acreditado' => 'required',
                'id_cat_sexo' => 'required',
                'id_cat_comprobante_ingreso' => 'required',
                'id_cat_identificacion' => 'required',
                'curp' => 'required',
                'rfc' => 'required',
                'fecha_ingreso' => 'required',
                'fecha_nacimiento' => 'required',
                'direccion' => '',
                'quien_es_quien' => 'required',
                'actua_por' => 'required',
                'activo' => 'required',
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {
                    $archivos = $data_request['data']["archivos"];
                    //Validar la CURP y RFC
                    if ($this->validate_curp($data_request['data']["curp"])) {

                        if ($this->valida_rfc($data_request['data']["rfc"])) {

                            $this->IDAOExpediente->setIdAcreditado($data_request['data']["id_acreditado"]);
                            $this->IDAOExpediente->setIdCatSexo($data_request['data']["id_cat_sexo"]);
                            $this->IDAOExpediente->setIdCatComprobanteIngreso($data_request['data']["id_cat_comprobante_ingreso"]);
                            $this->IDAOExpediente->setIdCatIdentificacion($data_request['data']["id_cat_identificacion"]);
                            $this->IDAOExpediente->setCurp(strtoupper($data_request['data']["curp"]));
                            $this->IDAOExpediente->setRfc(strtoupper($data_request['data']["rfc"]));
                            $this->IDAOExpediente->setCurpValido($data_request['data']["curp_valido"]);
                            $this->IDAOExpediente->setRfcValido($data_request['data']["rfc_valido"]);
                            $this->IDAOExpediente->setFechaNacimiento($data_request['data']["fecha_nacimiento"]);
                            $this->IDAOExpediente->setFechaIngreso($data_request['data']["fecha_ingreso"]);
                            $this->IDAOExpediente->setDireccion($data_request['data']["direccion"]);
                            $this->IDAOExpediente->setQuienEsQuien($data_request['data']["quien_es_quien"]);
                            $this->IDAOExpediente->setActuaPor($data_request['data']["actua_por"]);
                            $this->IDAOExpediente->setActivo($data_request['data']["activo"]);

                            $insert_data = $this->IDAOExpediente->create();

                            if ($insert_data > 0 && count($archivos) > 0) {
                                foreach ($archivos as $key => $row) {

                                    $this->IDAOExpedienteArchivo->setIdExpedienteArchivo(null);
                                    $this->IDAOExpedienteArchivo->setIdExpediente($insert_data);
                                    $this->IDAOExpedienteArchivo->setIdCatArchivoIntegracionExpediente($row["id_cat_archivo_integracion_expediente"]);
                                    $this->IDAOExpedienteArchivo->setTitulo($row["titulo"]);
                                    $this->IDAOExpedienteArchivo->setTipoDoc($row["tipo_doc"]);
                                    $this->IDAOExpedienteArchivo->setValidado($row["validado"]);
                                    $this->IDAOExpedienteArchivo->setDescripcion($row["descripcion"]);
                                    $this->IDAOExpedienteArchivo->setIdArchivo($row["id_archivo"]);
                                    $this->IDAOExpedienteArchivo->setArchivo($row["archivo"]);
                                    $this->IDAOExpedienteArchivo->setActivo(1);

                                    $this->IDAOExpedienteArchivo->create();

                                }

                            }

                            if ($insert_data > 0) {
                                $flag_request = true;
                                $status = 200;
                                $message = "Datos guardados con éxito.";
                                $data = $insert_data;
                                DB::commit();
                            } else {
                                $flag_request = false;
                                $status = 400;
                                $message = "Error al guardar los datos.";
                                $data = array();
                                DB::rollback();
                            }
                        } else {
                            $flag_request = false;
                            $status = 400;
                            $message = "RFC no válida.";
                            $data = array();
                            DB::rollback();
                        }

                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "CURP no válida.";
                        $data = array();
                        DB::rollback();
                    }


                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function modificar_expediente(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_expediente' => 'required',
                'id_acreditado' => 'required',
                'id_cat_sexo' => 'required',
                'id_cat_comprobante_ingreso' => 'required',
                'id_cat_identificacion' => 'required',
                'curp' => 'required',
                'rfc' => 'required',
                'fecha_ingreso' => 'required',
                'fecha_nacimiento' => 'required',
                'direccion' => '',
                'quien_es_quien' => 'required',
                'actua_por' => 'required',
                'activo' => 'required',
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $id_expediente = $data_request['data']["id_expediente"];
                    $this->IDAOExpediente->setIdExpediente($id_expediente);
                    $existe_registro = $this->IDAOExpediente->show();

                    if ($existe_registro) {
                        $archivos = $data_request['data']["archivos"];
                        //Validar la CURP y RFC
                        if ($this->validate_curp($data_request['data']["curp"])) {

                            if ($this->valida_rfc($data_request['data']["rfc"])) {
                                $this->IDAOExpediente->setIdExpediente($id_expediente);
                                $this->IDAOExpediente->setIdAcreditado($data_request['data']["id_acreditado"]);
                                $this->IDAOExpediente->setIdCatSexo($data_request['data']["id_cat_sexo"]);
                                $this->IDAOExpediente->setIdCatComprobanteIngreso($data_request['data']["id_cat_comprobante_ingreso"]);
                                $this->IDAOExpediente->setIdCatIdentificacion($data_request['data']["id_cat_identificacion"]);
                                $this->IDAOExpediente->setCurp(strtoupper($data_request['data']["curp"]));
                                $this->IDAOExpediente->setRfc(strtoupper($data_request['data']["rfc"]));
                                $this->IDAOExpediente->setCurpValido($data_request['data']["curp_valido"]);
                                $this->IDAOExpediente->setRfcValido($data_request['data']["rfc_valido"]);
                                $this->IDAOExpediente->setFechaNacimiento($data_request['data']["fecha_nacimiento"]);
                                $this->IDAOExpediente->setFechaIngreso($data_request['data']["fecha_ingreso"]);
                                $this->IDAOExpediente->setDireccion($data_request['data']["direccion"]);
                                $this->IDAOExpediente->setQuienEsQuien($data_request['data']["quien_es_quien"]);
                                $this->IDAOExpediente->setActuaPor($data_request['data']["actua_por"]);
                                $this->IDAOExpediente->setActivo($data_request['data']["activo"]);

                                $update_data = $this->IDAOExpediente->update();

                                $flag = true;

                                $this->IDAOExpedienteArchivo->setIdExpediente($id_expediente);
                                $expedientes_update = $this->IDAOExpedienteArchivo->all();
                                $actualizados = array();

                                foreach ($expedientes_update as $key => $row) {
                                    $this->IDAOExpedienteArchivo->setIdExpedienteArchivo($row->id_expediente_archivo);
                                    $this->IDAOExpedienteArchivo->setIdExpediente($row->id_expediente);
                                    $this->IDAOExpedienteArchivo->setIdCatArchivoIntegracionExpediente(0);
                                    $this->IDAOExpedienteArchivo->setTitulo(null);
                                    $this->IDAOExpedienteArchivo->setDescripcion(null);
                                    $this->IDAOExpedienteArchivo->setArchivo(null);
                                    $this->IDAOExpedienteArchivo->setIdArchivo(null);
                                    $this->IDAOExpedienteArchivo->setTipoDoc(null);
                                    $this->IDAOExpedienteArchivo->setValidado(null);
                                    $this->IDAOExpedienteArchivo->setActivo(0);
                                    $actualizados[] = $this->IDAOExpedienteArchivo->update();
                                }

                                foreach ($archivos as $key => $row) {
                                    $id_expediente_archivo = $row['id_expediente_archivo'] ?? null;

                                    if ($id_expediente_archivo > 0) {
                                        $this->IDAOExpedienteArchivo->setIdExpedienteArchivo($id_expediente_archivo);
                                        $this->IDAOExpedienteArchivo->setIdExpediente($id_expediente);
                                        $this->IDAOExpedienteArchivo->setIdCatArchivoIntegracionExpediente($row["id_cat_archivo_integracion_expediente"]);
                                        $this->IDAOExpedienteArchivo->setTitulo($row["titulo"]);
                                        $this->IDAOExpedienteArchivo->setTipoDoc($row["tipo_doc"]);
                                        $this->IDAOExpedienteArchivo->setValidado($row["validado"]);
                                        $this->IDAOExpedienteArchivo->setDescripcion($row["descripcion"]);
                                        $this->IDAOExpedienteArchivo->setIdArchivo($row["id_archivo"]);
                                        $this->IDAOExpedienteArchivo->setArchivo($row["archivo"]);
                                        $this->IDAOExpedienteArchivo->setActivo(1);

                                        $id_recordatorio_producto = $this->IDAOExpedienteArchivo->update();

                                        if (!$id_recordatorio_producto) {
                                            $flag = false;
                                        }
                                    } else {
                                        $this->IDAOExpedienteArchivo->setIdExpedienteArchivo(null);
                                        $this->IDAOExpedienteArchivo->setIdExpediente($id_expediente);
                                        $this->IDAOExpedienteArchivo->setIdCatArchivoIntegracionExpediente($row["id_cat_archivo_integracion_expediente"]);
                                        $this->IDAOExpedienteArchivo->setTitulo($row["titulo"]);
                                        $this->IDAOExpedienteArchivo->setTipoDoc($row["tipo_doc"] ?? 2);
                                        $this->IDAOExpedienteArchivo->setValidado($row["validado"] ?? 2);
                                        $this->IDAOExpedienteArchivo->setDescripcion($row["descripcion"] ?? '');
                                        $this->IDAOExpedienteArchivo->setIdArchivo($row["id_archivo"]);
                                        $this->IDAOExpedienteArchivo->setArchivo($row["archivo"]);
                                        $this->IDAOExpedienteArchivo->setActivo(1);

                                        $id_recordatorio_producto = $this->IDAOExpedienteArchivo->create();

                                        if (!$id_recordatorio_producto) {
                                            $flag = false;
                                        }
                                    }
                                }


                                if ($update_data > 0 && $flag) {
                                    $flag_request = true;
                                    $status = 200;
                                    $message = "Datos actualizados con éxito.";
                                    $data = array();
                                    DB::commit();
                                } else {
                                    $flag_request = false;
                                    $status = 400;
                                    $message = "Error al actualizar los datos.";
                                    $data = array();
                                    DB::rollback();
                                }

                            } else {
                                $flag_request = false;
                                $status = 400;
                                $message = "RFC no válida.";
                                $data = array();
                                DB::rollback();
                            }

                        } else {
                            $flag_request = false;
                            $status = 400;
                            $message = "CURP no válida.";
                            $data = array();
                            DB::rollback();
                        }

                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "No existe este registro.";
                        $data = array();
                        DB::rollback();
                    }

                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function eliminar_expediente(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'id_orientacion' => 'required'
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $this->IDAOExpediente->setIdZona($data_request['data']["id_expediente"]);
                    $existe_registro = $this->IDAOExpediente->show();

                    if ($existe_registro) {

                        $this->IDAOExpediente->setIdZona($data_request['data']["id_expediente"]);
                        $delete_data = $this->IDAOExpediente->delete();

                        if ($delete_data > 0) {
                            $flag_request = true;
                            $status = 200;
                            $message = "Datos eliminados con éxito.";
                            $data = array();
                            DB::commit();
                        } else {
                            $flag_request = false;
                            $status = 400;
                            $message = "Error al eliminar los datos.";
                            $data = array();
                            DB::rollback();
                        }
                    } else {
                        $flag_request = false;
                        $status = 400;
                        $message = "No existe el registro que intentas eliminar.";
                        $data = array();
                        DB::rollback();
                    }

                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

    public function validacion_expediente(Request $request)
    {
        $data_request = $this->get_data_request($request);

        $flag_request = false;

        if ($this->ACCESSTOKEN($data_request['token'], $data_request['credenciales'], $Usr, $errors)) {

            $validator = Validator::make($data_request['data'], [
                'validated' => 'required'
            ]);

            if (!$validator->fails()) {

                DB::beginTransaction();

                try {

                    $validated = $data_request['data']["validated"];
                    $curp = $data_request['data']["curp"] ?? "";
                    $rfc = $data_request['data']["rfc"] ?? "";

                    if ($validated == 'curp') {

                        $client = new Client([
                            'headers' => [
                                'Content-Type' => 'application/json',
                                'x-rapidapi-host' => 'curp-renapo.p.rapidapi.com',
                                'x-rapidapi-key' => '9b0a53e9f6msh13c3517dc5a0b14p1d64a2jsn1792add0150f'
                            ]
                        ]);

                        $body = json_encode(
                            [
                                'curp' => $curp
                            ]
                        );

                        $result = (object)["birthdate" => "16/08/1989",
                            "curp" => "MEAC890816HCSDRR00",
                            "mothers_maiden_name" => "ARIAS",
                            "names" => "CARLOS ALBERTO",
                            "nationality" => "MEXICO",
                            "paternal_surname" => "MEDINA",
                            "probation_document" => "ACTA DE NACIMIENTO",
                            "valido" => true,
                            "renapo_valid" => true,
                            "sex" => "HOMBRE",
                            "status_curp" => "RCN"];

                        /*id_expediente: data.id_expediente || "",
								birthdate: data.birthdate || "",
								curp: data.curp || "",
								apellido_materno: data.mothers_maiden_name || "",
								nombre: data.names || "",
								nacionalidad: data.nationality || "",
								apellido_paterno: data.paternal_surname || "",
								aprobacion_documento: data.probation_document || "",
								aprobacion_documento_data: data.probation_document_data || {},
								valido: data.renapo_valid || false,
								sexo: data.sex || "",
								estatus: data.status_curp || "",
								activo: (data.activo === 1),*/


                        $flag_request = true;
                        $status = 200;
                        $message = $validated == "curp" ? "CURP: " . $curp . " validado con éxito." : "RFC: " . $rfc . " validado con éxito.";
                        $data = $result;
                        DB::commit();

                        /* try{
                             $client = $client->post('https://curp-renapo.p.rapidapi.com/v1/curp', ['body' => $body]);
                             $res = $client->getBody();
                             $result = json_decode($res);
                             if ($result > 0) {
                                 $flag_request = true;
                                 $status = 200;
                                 $message = $validated == "curp" ? "CURP: " . $curp . " validado con éxito.":"RFC: " . $rfc . " validado con éxito.";
                                 $data = $result;
                                 DB::commit();
                             } else {
                                 $flag_request = false;
                                 $status = 400;
                                 $message = "Error al validar los datos.";
                                 $data = array();
                                 DB::rollback();
                             }

                         } catch (\Exception $e) {
                             if ($e->getCode() == 429) {
                                 $flag_request = false;
                                 $status = 400;
                                 $message = "Ha superado la cuota mensual de solicitudes.";
                                 $data = array();
                                 DB::rollback();
                             }
                         }*/

                    } else {
                        $client = new Client([
                            'headers' => [
                                'Content-Type' => 'application/json',
                                'x-rapidapi-host' => 'curp-renapo.p.rapidapi.com',
                                'x-rapidapi-key' => '9b0a53e9f6msh13c3517dc5a0b14p1d64a2jsn1792add0150f'
                            ]
                        ]);

                        $body = json_encode(
                            [
                                'curp' => $curp
                            ]
                        );

                        $client = $client->post('https://curp-renapo.p.rapidapi.com/v1/curp', ['body' => $body]);

                        $res = $client->getBody();
                        $result = json_decode($res);
                        dd("Resultado:", $result);
                        if ($result > 0) {
                            $flag_request = true;
                            $status = 200;
                            $message = $validated == "curp" ? "CURP: " . $curp . " validado con éxito." : "RFC: " . $rfc . " validado con éxito.";
                            $data = $result;
                            DB::commit();
                        } else {
                            $flag_request = false;
                            $status = 400;
                            $message = "Error al validar los datos.";
                            $data = array();
                            DB::rollback();
                        }
                    }


                    $response = [
                        "success" => $flag_request,
                        "status" => $status,
                        "message" => $message,
                        "data" => $data
                    ];

                } catch (Exception $e) {
                    DB::rollback();
                    $log = $this->ErrorTransaction($e, $request);
                    return $log;
                }
            } else {
                $response = [
                    "success" => $flag_request,
                    "status" => 400,
                    "message" => "No se encontraron datos.",
                    "errors" => $validator->errors()->messages()
                ];
            }

        } else {
            $response = array(
                'success' => $flag_request,
                'status' => 400,
                'message' => 'Acceso denegado, token de acceso no válido',
                "errors" => $errors
            );
        }

        return $response;
    }

}
