<?php

namespace App\Http\Controllers\SIS;

use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Routing\Controller as BaseController;

class ProcessingSendMail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $vista = null;
    protected $correo = null;
    protected $nombre = null;
    protected $asunto = null;
    protected $mensaje = null;
    protected $archivos = [];

    public function __construct($vista, $correo, $nombre, $asunto, $mensaje, $archivos)
    {
        $this->vista = $vista;
        $this->correo = $correo;
        $this->nombre = $nombre;
        $this->asunto = $asunto;
        $this->mensaje = $mensaje;
        $this->archivos = $archivos;
    }

    public function handle()
    {
        $vista = $this->vista;
        $correo = $this->correo;
        $nombre = $this->nombre;
        $asunto = $this->asunto;
        $mensaje = $this->mensaje;
        $archivos = $this->archivos;

        try {
            //$ vista = 'emails-send-cfdi'
            Mail::send($vista, ['mensaje' => $mensaje], function ($m) use ($correo, $nombre, $asunto, $archivos) {

                $m->from(env('MAIL_USERNAME'), env('FROM_NAME_SOUPORT'));

                foreach ($archivos as $row) {
                    $m->attach($row);
                }

                $m->to($correo, $nombre)->subject($asunto ?? '');

            });
        } catch (Exception $e) {
            return 'Excepción capturada: ' . $e->getMessage();
        }
    }
}
