<?php

namespace App\Http\Controllers\SIS;

use Pusher\Pusher as PusherLibrary;
use Pusher\PusherException;

class Pusher
{

    public $channel;
    public $event;
    public $data;
    public $socket_id = null;
    public $debug = false;
    public $already_encoded = false;

    /**
     * Pusher constructor.
     */
    public function __construct()
    {
    }

    /**
     * @return mixed
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * @param mixed $channel
     */
    public function setChannel($channel): void
    {
        $this->channel = $channel;
    }

    /**
     * @return mixed
     */
    public function getEvent()
    {
        return $this->event;
    }

    /**
     * @param mixed $event
     */
    public function setEvent($event): void
    {
        $this->event = $event;
    }

    /**
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param mixed $data
     */
    public function setData($data): void
    {
        $this->data = $data;
    }

    /**
     * @return null
     */
    public function getSocketId()
    {
        return $this->socket_id;
    }

    /**
     * @param null $socket_id
     */
    public function setSocketId($socket_id): void
    {
        $this->socket_id = $socket_id;
    }

    /**
     * @return bool
     */
    public function isDebug(): bool
    {
        return $this->debug;
    }

    /**
     * @param bool $debug
     */
    public function setDebug(bool $debug): void
    {
        $this->debug = $debug;
    }

    /**
     * @return bool
     */
    public function isAlreadyEncoded(): bool
    {
        return $this->already_encoded;
    }

    /**
     * @param bool $already_encoded
     */
    public function setAlreadyEncoded(bool $already_encoded): void
    {
        $this->already_encoded = $already_encoded;
    }

    public function SendData() {

        $options = array(
            'cluster' => env('PUSHER_APP_CLUSTER'),
            'useTLS' => env('PUSHER_APP_USETLS')
        );

        try {

            $pusher = new PusherLibrary(
                env('PUSHER_APP_KEY'),
                env('PUSHER_APP_SECRET'),
                env('PUSHER_APP_ID'),
                $options
            );

            $chanel = $this->getChannel();
            $event = $this->getEvent();
            $data = $this->getData();

            return $pusher->trigger($chanel, $event, $data);

        } catch (PusherException $e) {
            return $e;
        }

    }

}

?>


