<?php

namespace App\Http\Dao\Implement;

use App\Http\Dao\Interfaces\DAOAlumnos;
use App\Http\Dto\DTOAlumnos;
use Illuminate\Support\Facades\DB;

class IDAOAlumnos extends DTOAlumnos implements DAOAlumnos
{

    public function all(&$paginacion)
    {
        $nombre = $this->getFiltroNombre() ?? '';
        $correo_electronico = $this->getFiltroCorreoElectronico() ?? '';
        $telefono = $this->getFiltroTelefono() ?? '';
        $activo = $this->getFiltroActivo() ?? '';

        $page = (integer)$this->getPage() ?? 1;
        $limit = (integer)$this->getLimit() ?? 5;


        $TBLQuery = DB::table('alumno')
            ->select( DB::raw("SQL_CALC_FOUND_ROWS alumno.*"),'alumno.*', 'cat_modalidad.modalidad', 'cat_nivel.nivel', 'cat_horario.horario', 'cat_tipo_inscripcion.tipo_inscripcion',
            DB::raw('CONCAT(alumno.nombre, " ", alumno.apellido_paterno, " ", alumno.apellido_materno) AS nombre_completo'),
            DB::raw('CONCAT(usuario.nombre, " ", usuario.apellido_paterno, " ", usuario.apellido_materno) AS instructor'))
            ->leftJoin('usuario', 'usuario.id_usuario', '=', 'alumno.id_usuario')
            ->leftJoin('cat_modalidad', 'cat_modalidad.id_cat_modalidad', '=', 'alumno.id_cat_modalidad')
            ->leftJoin('cat_nivel', 'cat_nivel.id_cat_nivel', '=', 'alumno.id_cat_nivel')
            ->leftJoin('cat_horario', 'cat_horario.id_cat_horario', '=', 'alumno.id_cat_horario')
            ->leftJoin('cat_tipo_inscripcion', 'cat_tipo_inscripcion.id_cat_tipo_inscripcion', '=', 'alumno.id_cat_tipo_inscripcion');

        if ($nombre) {
            $w = sprintf("(alumno.nombre like '%s' or alumno.apellido_paterno like '%s' or alumno.apellido_materno like '%s' or (CONCAT(IFNULL(alumno.nombre, ''), ' ', IFNULL(alumno.apellido_paterno, ''), ' ', IFNULL(alumno.apellido_materno, ''))) like '%s' or alumno.razon_social like '%s')",
                "%" . $nombre . "%",
                "%" . $nombre . "%",
                "%" . $nombre . "%",
                "%" . $nombre . "%",
                "%" . $nombre . "%"
            );
            $TBLQuery->whereRaw($w);
        }

        if ($correo_electronico) {
            $w = sprintf("(alumno.correo_electronico = '%s' or alumno.correo_electronico like '%s')",
                "%" . $correo_electronico . "%",
                "%" . $correo_electronico . "%"
            );
            $TBLQuery->whereRaw($w);
        }

        if ($telefono) {
            $w = sprintf("(alumno.telefono like '%s')","%". $telefono ."%");
            $TBLQuery->whereRaw($w);
        }

        if ($activo === 1 || $activo === 0) {
            $w = sprintf("alumno.activo = %s", $activo);
            $TBLQuery->whereRaw($w);
        }

        $TBLQuery->orderBy('alumno.id_alumno', 'DESC');

        if ($this->getPage() > 0 && $this->getLimit() > 0) {
            $page = $this->getPage();
            $limit = $this->getLimit();
            $offset = ($page - 1) * $limit;
            $TBLQuery->limit($this->getLimit())->offset($offset);
        }

        $result = $TBLQuery->get();

        $total = DB::select(DB::raw('SELECT FOUND_ROWS() as total'))[0]->total;

        $paginacion = (object)array(
            'total' => $total,
            'page' => $page ?? 1,
            'limit' => $limit ?? '∞'
        );

        return $result;
    }

    public function create()
    {
        $inset = DB::table('alumno')
            ->insertGetId([
                //"id_alumno" => $this->getIdAlumno(),
                "nombre" => $this->getNombre(),
                "apellido_paterno" => $this->getApellidoPaterno(),
                "apellido_materno" => $this->getApellidoMaterno(),
                "telefono" => $this->getTelefono(),
                "numero_emergencia" => $this->getNumeroEmergencia(),
                "correo_electronico" => $this->getCorreoElectronico(),
                "tipo_sangre" => $this->getTipoSangre(),
                "fecha_nacimiento" => $this->getFechaNacimiento(),
                "lugar_nacimiento" => $this->getLugarNacimiento(),
                "codigo_postal" => $this->getCodigoPostal(),
                "direccion" => $this->getDireccion(),
                "alergia_lesion_otro" => $this->getAlergiaLesionOtro(),
                "tutor" => $this->getTutor(),
                "fecha_ingreso" => $this->getFechaIngreso(),
                "id_cat_modalidad" => $this->getIdCatModalidad(),
                "id_cat_nivel" => $this->getIdCatNivel(),
                "id_cat_horario" => $this->getIdCatHorario(),
                "id_cat_tipo_inscripcion" => $this->getIdCatTipoInscripcion(),
                "costo" => $this->getCosto(),
                "fecha_inicio_pago" => $this->getFechaInicioPago(),
                "fecha_fin_pago" => $this->getFechaFinPago(),
                "id_usuario" => $this->getIdUsuario(),
                "certificado_medico" => $this->getCertificadoMedico(),
                "responsiva" => $this->getResponsiva(),
                "edad" => $this->getEdad(),
                "foto" => $this->getFoto(),
                "notas" => $this->getNotas(),
                "activo" => $this->getActivo(),
                "created_at" => $this->DATETIME(),
                "updated_at" => $this->DATETIME()
            ]);

        return $inset;
    }

    public function update()
    {
        $update = DB::table('alumno')
            ->where('alumno.id_alumno', '=', $this->getIdAlumno())
            ->update([
                "nombre" => $this->getNombre(),
                "apellido_paterno" => $this->getApellidoPaterno(),
                "apellido_materno" => $this->getApellidoMaterno(),
                "telefono" => $this->getTelefono(),
                "numero_emergencia" => $this->getNumeroEmergencia(),
                "correo_electronico" => $this->getCorreoElectronico(),
                "tipo_sangre" => $this->getTipoSangre(),
                "fecha_nacimiento" => $this->getFechaNacimiento(),
                "lugar_nacimiento" => $this->getLugarNacimiento(),
                "codigo_postal" => $this->getCodigoPostal(),
                "direccion" => $this->getDireccion(),
                "alergia_lesion_otro" => $this->getAlergiaLesionOtro(),
                "tutor" => $this->getTutor(),
                "fecha_ingreso" => $this->getFechaIngreso(),
                "id_cat_modalidad" => $this->getIdCatModalidad(),
                "id_cat_nivel" => $this->getIdCatNivel(),
                "id_cat_horario" => $this->getIdCatHorario(),
                "id_cat_tipo_inscripcion" => $this->getIdCatTipoInscripcion(),
                "costo" => $this->getCosto(),
                "fecha_inicio_pago" => $this->getFechaInicioPago(),
                "fecha_fin_pago" => $this->getFechaFinPago(),
                "id_usuario" => $this->getIdUsuario(),
                "certificado_medico" => $this->getCertificadoMedico(),
                "responsiva" => $this->getResponsiva(),
                "edad" => $this->getEdad(),
                "foto" => $this->getFoto(),
                "notas" => $this->getNotas(),
                "activo" => $this->getActivo(),
                "updated_at" => $this->DATETIME()
            ]);

        return $update;
    }

    public function delete()
    {
        $del = DB::table('alumno')
            ->where('alumno.id_alumno', '=', $this->getIdAcreditado())
            ->update([
                "activo" => $this->getActivo(),
                "updated_at" => $this->DATETIME()
            ]);

        return $del;
    }

    public function show()
    {
        $row = DB::table('alumno')->select('alumno.*')->where('alumno.id_alumno', '=', $this->getIdAlumno())->first();

        if ($row) {
            return (object)$row;
        } else {
            return null;
        }
    }

}
