<?php

namespace App\Http\Dao\Implement;

use App\Http\Dao\Interfaces\DAOComentario;
use App\Http\Dto\DTOComentario;
use Illuminate\Support\Facades\DB;

class IDAOComentario extends DTOComentario implements DAOComentario
{

    public function all()
    {
        $result = DB::table('comentario')
            ->select('comentario.*',
                'ruta.id_ruta',
                'ruta.ruta')
            ->leftJoin('ruta', 'ruta.id_ruta', '=', 'comentario.id_ruta')
            ->get();

        return $result;
    }

    public function create()
    {
        $inset = DB::table('comentario')
            ->insertGetId([
                "id_ruta" => $this->getIdRuta(),
                "id_usuario" => $this->getIdUsuario(),
                "comentario" => $this->getComentario(),
                "activo" => $this->getActivo(),
                "created_at" => $this->DATETIME(),
                "updated_at" => $this->DATETIME()
            ]);

        return $inset;
    }

    public function update()
    {
        $update = DB::table('comentario')
            ->where('comentario.id_comentario', '=', $this->getIdComentario())
            ->update([
                "id_ruta" => $this->getIdRuta(),
                "id_usuario" => $this->getIdUsuario(),
                "comentario" => $this->getComentario(),
                "activo" => $this->getActivo(),
                "updated_at" => $this->DATETIME()
            ]);

        return $update;
    }

    public function delete()
    {
        $del = DB::table('comentario')->where('comentario.id_comentario', '=', $this->getIdComentario())->delete();

        return $del;
    }

    public function show()
    {
        $row = DB::table('comentario')->select('comentario.*')->where('comentario.id_comentario', '=', $this->getIdComentario())->first();

        if ($row) {
            return (object)$row;
        } else {
            return null;
        }
    }

}
