<?php

namespace App\Http\Dao\Implement;

use App\Http\Dao\Interfaces\DAOExpediente;
use App\Http\Dto\DTOExpediente;
use Illuminate\Support\Facades\DB;

class IDAOExpediente extends DTOExpediente implements DAOExpediente
{

    public function all(&$paginacion)
    {
        $id_expediente = $this->getFiltroIdExpediente() ?? '';
        $nombre = $this->getFiltroNombre() ?? '';
        $id_cat_identificacion = $this->getFiltroIdCatIdentificacion() ?? '';
        $curp = $this->getFiltroCurp() ?? '';
        $rfc = $this->getFiltroRfc() ?? '';
        $fecha_ingreso = $this->getFiltroFechaIngreso() ?? '';
        $activo = $this->getFiltroActivo() ?? '';

        $page = (integer)$this->getPage() ?? 1;
        $limit = (integer)$this->getLimit() ?? 5;


        $TBLQuery = DB::table('expediente')
            ->select(DB::raw("SQL_CALC_FOUND_ROWS expediente.*"), 'expediente.*',
                DB::raw('CONCAT(acreditado.nombre, " ", acreditado.apellido_paterno, " ", acreditado.apellido_materno) AS nombre_completo'),
                'cat_sexo.sexo',
                'cat_comprobante_ingreso.comprobante_ingreso',
                'cat_identificacion.identificacion'
            )
            ->leftJoin('acreditado', 'acreditado.id_acreditado', '=', 'expediente.id_acreditado')
            ->leftJoin('cat_sexo', 'cat_sexo.id_cat_sexo', '=', 'expediente.id_cat_sexo')
            ->leftJoin('cat_comprobante_ingreso', 'cat_comprobante_ingreso.id_cat_comprobante_ingreso', '=', 'expediente.id_cat_comprobante_ingreso')
            ->leftJoin('cat_identificacion', 'cat_identificacion.id_cat_identificacion', '=', 'expediente.id_cat_identificacion');

        if ($nombre) {
            $w = sprintf("(acreditado.nombre like '%s' or acreditado.apellido_paterno like '%s' or acreditado.apellido_materno like '%s' or (CONCAT(IFNULL(acreditado.nombre, ''), ' ', IFNULL(acreditado.apellido_paterno, ''), ' ', IFNULL(acreditado.apellido_materno, ''))) like '%s')",
                "%" . $nombre . "%",
                "%" . $nombre . "%",
                "%" . $nombre . "%",
                "%" . $nombre . "%"
            );
            $TBLQuery->whereRaw($w);
        }

        if ($id_expediente > 0) {
            $w = sprintf("expediente.id_expediente = %s", $id_expediente);
            $TBLQuery->whereRaw($w);
        }

        if ($id_cat_identificacion > 0) {
            $w = sprintf("expediente.id_cat_identificacion = %s", $id_cat_identificacion);
            $TBLQuery->whereRaw($w);
        }

        if ($curp) {
            $w = sprintf("(expediente.curp like '%s')", "%" . $curp . "%");
            $TBLQuery->whereRaw($w);
        }

        if ($rfc) {
            $w = sprintf("(expediente.rfc like '%s')", "%" . $rfc . "%");
            $TBLQuery->whereRaw($w);
        }

        /*if ($fecha_ingreso) {
            $w = sprintf("(expediente.fecha_ingreso like '%s')","%". $fecha_ingreso ."%");
            $TBLQuery->whereRaw($w);
        }*/

        if ($activo === 1 || $activo === 0) {
            $w = sprintf("expediente.activo = %s", $activo);
            $TBLQuery->whereRaw($w);
        }

        $TBLQuery->orderBy('expediente.id_expediente', 'DESC');

        if ($this->getPage() > 0 && $this->getLimit() > 0) {
            $page = $this->getPage();
            $limit = $this->getLimit();
            $offset = ($page - 1) * $limit;
            $TBLQuery->limit($this->getLimit())->offset($offset);
        }

        $result = $TBLQuery->get();

        $total = DB::select(DB::raw('SELECT FOUND_ROWS() as total'))[0]->total;

        $paginacion = (object)array(
            'total' => $total,
            'page' => $page ?? 1,
            'limit' => $limit ?? '∞'
        );

        $cat_expediente = DB::table('cat_archivo_integracion_expediente')
            ->select('cat_archivo_integracion_expediente.*')
            ->get();

        $expedientes_requeridos = 0;

        foreach ($result as $row) {

            if (intval($row->quien_es_quien) === 1) {
                $row->quien = "Ok";
            } else {
                $row->quien = "No apto";
            }
            if (intval($row->actua_por) === 1) {
                $row->actua = "No";
            } else {
                $row->actua = "Si";
            }

            $row->comprobante_ingreso = ucfirst(mb_strtolower($row->comprobante_ingreso));
            $row->id_cat_comprobante_ingreso = strval($row->id_cat_comprobante_ingreso);
            $row->id_cat_identificacion = strval($row->id_cat_identificacion);
            $row->quien_es_quien = strval($row->quien_es_quien);
            $row->actua_por = strval($row->actua_por);

            $expedientes = DB::table('expediente_archivo')
                ->select('expediente_archivo.*',
                    'cat_archivo_integracion_expediente.archivo_integracion_expediente'
                )
                ->leftJoin('cat_archivo_integracion_expediente', 'cat_archivo_integracion_expediente.id_cat_archivo_integracion_expediente', '=', 'expediente_archivo.id_cat_archivo_integracion_expediente')
                ->where('expediente_archivo.id_expediente', '=', $row->id_expediente)
                ->where('expediente_archivo.activo', '=', 1)
                ->get();


            foreach ($cat_expediente as $rowea) {
                $rowea->titulo = $rowea->archivo_integracion_expediente;
                if ($rowea->is_required) {
                    $expedientes_requeridos++;
                }
                foreach ($expedientes as $rowe) {
                    if ($rowea->id_cat_archivo_integracion_expediente == $rowe->id_cat_archivo_integracion_expediente) {
                        $formato = explode(".", $rowe->archivo);

                        $rowea->id_expediente_archivo = $rowe->id_expediente_archivo;
                        $rowea->id_expediente = $rowe->id_expediente;
                        $rowea->titulo = $rowe->titulo;
                        $rowea->descripcion = $rowe->descripcion;
                        $rowea->archivo = $rowe->archivo;
                        $rowea->formato = $formato[count($formato)-1];
                        $rowea->id_archivo = $rowe->id_archivo;
                        $rowea->tipo_doc = strval($rowe->tipo_doc);
                        $rowea->validado = strval($rowe->validado);
                    }
                }
            }

            $complete_expediente = number_format((100 * (count($expedientes) >= $expedientes_requeridos ? $expedientes_requeridos:count($expedientes))) / $expedientes_requeridos, 2, '.', '');
            $row->completed_expedientes = $complete_expediente;
            $row->value_expedientes = $complete_expediente;
            $row->color_expedientes = $complete_expediente < 80 ? $complete_expediente <= 50 ? 4:1:5;
            $row->listar_archivo_integracion_expediente = $cat_expediente;
        }

        return $result;
    }

    public function create()
    {
        $inset = DB::table('expediente')
            ->insertGetId([
                "id_acreditado" => $this->getIdAcreditado(),
                "id_cat_sexo" => $this->getIdCatSexo(),
                "id_cat_comprobante_ingreso" => $this->getIdCatComprobanteIngreso(),
                "id_cat_identificacion" => $this->getIdCatIdentificacion(),
                "curp" => $this->getCurp(),
                "rfc" => $this->getRfc(),
                "fecha_nacimiento" => $this->getFechaNacimiento(),
                "fecha_ingreso" => $this->getFechaIngreso(),
                "direccion" => $this->getDireccion(),
                "quien_es_quien" => $this->getQuienEsQuien(),
                "actua_por" => $this->getActuaPor(),
                "activo" => $this->getActivo(),
                "created_at" => $this->DATETIME(),
                "updated_at" => $this->DATETIME()
            ]);

        return $inset;
    }

    public function update()
    {
        $update = DB::table('expediente')
            ->where('expediente.id_expediente', '=', $this->getIdExpediente())
            ->update([
                "id_acreditado" => $this->getIdAcreditado(),
                "id_cat_sexo" => $this->getIdCatSexo(),
                "id_cat_comprobante_ingreso" => $this->getIdCatComprobanteIngreso(),
                "id_cat_identificacion" => $this->getIdCatIdentificacion(),
                "curp" => $this->getCurp(),
                "rfc" => $this->getRfc(),
                "fecha_nacimiento" => $this->getFechaNacimiento(),
                "fecha_ingreso" => $this->getFechaIngreso(),
                "direccion" => $this->getDireccion(),
                "quien_es_quien" => $this->getQuienEsQuien(),
                "actua_por" => $this->getActuaPor(),
                "activo" => $this->getActivo(),
                "updated_at" => $this->DATETIME()
            ]);

        return $update;
    }

    public function delete()
    {
        $del = DB::table('expediente')->where('expediente.id_expediente', '=', $this->getIdExpediente())->delete();

        return $del;
    }

    public function show()
    {
        $row = DB::table('expediente')
            ->select('expediente.*',DB::raw('CONCAT(acreditado.nombre, " ", acreditado.apellido_paterno, " ", acreditado.apellido_materno) AS nombre_completo'),
            'cat_comprobante_ingreso.comprobante_ingreso',
            'cat_identificacion.identificacion')
            ->where('expediente.id_expediente', '=', $this->getIdExpediente())
            ->leftJoin('acreditado', 'acreditado.id_acreditado', '=', 'expediente.id_acreditado')
            ->leftJoin('cat_comprobante_ingreso', 'cat_comprobante_ingreso.id_cat_comprobante_ingreso', '=', 'expediente.id_cat_comprobante_ingreso')
            ->leftJoin('cat_identificacion', 'cat_identificacion.id_cat_identificacion', '=', 'expediente.id_cat_identificacion')
            ->first();

        $cat_expediente = DB::table('cat_archivo_integracion_expediente')
            ->select('cat_archivo_integracion_expediente.*')
            ->get();

        $expedientes = DB::table('expediente_archivo')
            ->select('expediente_archivo.*',
                'cat_archivo_integracion_expediente.archivo_integracion_expediente'
            )
            ->leftJoin('cat_archivo_integracion_expediente', 'cat_archivo_integracion_expediente.id_cat_archivo_integracion_expediente', '=', 'expediente_archivo.id_cat_archivo_integracion_expediente')
            ->where('expediente_archivo.id_expediente', '=', $row->id_expediente)
            ->get();


        foreach ($cat_expediente as $rowea) {
            $rowea->tipo_doc = null;
            $rowea->validado = null;
            $rowea->descripcion = null;
            foreach ($expedientes as $rowe) {
                if ($rowea->id_cat_archivo_integracion_expediente == $rowe->id_cat_archivo_integracion_expediente) {
                    $rowea->titulo = $rowea->archivo_integracion_expediente;
                    $formato = explode(".", $rowe->archivo);
                    $rowea->id_expediente_archivo = $rowe->id_expediente_archivo;
                    $rowea->id_expediente = $rowe->id_expediente;
                    $rowea->titulo = $rowe->titulo;
                    $rowea->descripcion = $rowe->descripcion;
                    $rowea->archivo = $rowe->archivo;
                    $rowea->formato = $formato[count($formato)-1];
                    $rowea->id_archivo = $rowe->id_archivo;
                    $rowea->tipo_doc = strval($rowe->tipo_doc);
                    $rowea->validado = strval($rowe->validado);
                    $rowea->descripcion = strval($rowe->descripcion);
                }
            }
        }

        $row->listar_archivo_integracion_expediente = $cat_expediente;

        if ($row) {
            return (object)$row;
        } else {
            return null;
        }
    }

}
