<?php

namespace App\Http\Dao\Implement;

use App\Http\Dao\Interfaces\DAOExpediente;
use App\Http\Dao\Interfaces\DAOExpedienteArchivo;
use App\Http\Dto\DTOExpediente;
use App\Http\Dto\DTOExpedienteArchivo;
use Illuminate\Support\Facades\DB;

class IDAOExpedienteArchivo extends DTOExpedienteArchivo implements DAOExpedienteArchivo
{

    public function all()
    {
        $id_expediente = $this->getIdExpediente();

        $result = DB::table('expediente_archivo')
            ->select('expediente_archivo.*',
                'cat_archivo_integracion_expediente.archivo_integracion_expediente'
            )
            ->leftJoin('cat_archivo_integracion_expediente', 'cat_archivo_integracion_expediente.id_cat_archivo_integracion_expediente', '=', 'expediente_archivo.id_cat_archivo_integracion_expediente')
            ->where('expediente_archivo.id_expediente', '=', $id_expediente)
            ->get();

        return $result;
    }

    public function create()
    {
        $inset = DB::table('expediente_archivo')
            ->insertGetId([
                //"id_expediente_archivo" => $this->getIdExpedienteArchivo(),
                "id_expediente" => $this->getIdExpediente(),
                "id_cat_archivo_integracion_expediente" => $this->getIdCatArchivoIntegracionExpediente(),
                "titulo" => $this->getTitulo(),
                "descripcion" => $this->getDescripcion(),
                "archivo" => $this->getArchivo(),
                "id_archivo" => $this->getIdArchivo(),
                "tipo_doc" => $this->getTipoDoc(),
                "validado" => $this->getValidado(),
                "activo" => $this->getActivo(),
                "created_at" => $this->DATETIME(),
                "updated_at" => $this->DATETIME()
            ]);

        return $inset;
    }

    public function update()
    {
        $update = DB::table('expediente_archivo')
            ->where('expediente_archivo.id_expediente_archivo', '=', $this->getIdExpedienteArchivo())
            ->update([
                "id_expediente" => $this->getIdExpediente(),
                "id_cat_archivo_integracion_expediente" => $this->getIdCatArchivoIntegracionExpediente(),
                "titulo" => $this->getTitulo(),
                "descripcion" => $this->getDescripcion(),
                "archivo" => $this->getArchivo(),
                "id_archivo" => $this->getIdArchivo(),
                "tipo_doc" => $this->getTipoDoc(),
                "validado" => $this->getValidado(),
                "activo" => $this->getActivo(),
                "updated_at" => $this->DATETIME()
            ]);

        return $update;
    }

    public function delete()
    {
        $del = DB::table('expediente_archivo')->where('expediente_archivo.id_expediente_archivo', '=', $this->getIdExpedienteArchivo())->delete();

        return $del;
    }

    public function show()
    {
        $row = DB::table('expediente_archivo')->select('expediente_archivo.*')->where('expediente_archivo.id_expediente_archivo', '=', $this->getIdExpedienteArchivo())->first();

        if ($row) {
            return (object)$row;
        } else {
            return null;
        }
    }

}
