<?php

namespace App\Http\Dao\Implement;

use App\Http\Dao\Interfaces\DAOMonitor;
use App\Http\Dto\DTOMonitor;
use Illuminate\Support\Facades\DB;

class IDAOMonitor extends DTOMonitor implements DAOMonitor
{

    public function all()
    {
        $routs = DB::table('comentario')
            ->select('comentario.id_ruta')
            ->distinct()
            ->get();

        $result= array();
        for ($t=0; $t < count($routs); $t++) {
            $result[] = DB::table('comentario')
                ->select('comentario.*',
                    'ruta.id_ruta',
                    'ruta.ruta',
                    'zona.id_zona',
                    'zona.zona',
                    'orientacion.id_orientacion',
                    'orientacion.orientacion')
                ->where('comentario.id_ruta', '=', $routs[$t]->id_ruta)
                ->leftJoin('ruta', 'ruta.id_ruta', '=', 'comentario.id_ruta')
                ->leftJoin('zona', 'zona.id_zona', '=', 'ruta.id_zona')
                ->leftJoin('orientacion', 'orientacion.id_orientacion', '=', 'zona.id_orientacion')
                ->orderBy('comentario.id_comentario', 'DESC')
                ->first();
        }

        $zonas = DB::table('zona')
            ->select('zona.*',
                'orientacion.id_orientacion',
                'orientacion.orientacion')
            ->leftJoin('orientacion', 'orientacion.id_orientacion', '=', 'zona.id_orientacion')
            ->get();

        $orientaciones = DB::table('orientacion')
            ->select('orientacion.*')
            ->get();

        $res = [];
        for ($o = 0; $o < count($orientaciones); $o++) {
            $zon = [];
            for ($z = 0; $z < count($zonas); $z++) {
                if($orientaciones[$o]->id_orientacion === $zonas[$z]->id_orientacion) {
                    $rut = [];
                    if (count($result) > 0) {
                        for ($r = 0; $r < count($result); $r++) {
                            if($zonas[$z]->id_orientacion === $result[$r]->id_orientacion && $zonas[$z]->id_zona === $result[$r]->id_zona) {
                                $rut[] = $result[$r];
                            }
                        }
                        $zon[] = array("zona" => $zonas[$z]->zona, "rutas" => $rut);
                    }
                }
            }
            $res[] = array("orientacion" => $orientaciones[$o]->orientacion, "zonas" => $zon);
        }


        return $res;
    }

    public function create()
    {
        $inset = DB::table('comentario')
            ->insertGetId([
                "id_ruta" => $this->getIdRuta(),
                "comentario" => $this->getComentario(),
                "activo" => $this->getActivo(),
                "created_at" => $this->DATETIME(),
                "updated_at" => $this->DATETIME()
            ]);

        return $inset;
    }

    public function update()
    {
        $update = DB::table('comentario')
            ->where('comentario.id_comentario', '=', $this->getIdComentario())
            ->update([
                "id_ruta" => $this->getIdRuta(),
                "comentario" => $this->getComentario(),
                "activo" => $this->getActivo(),
                "updated_at" => $this->DATETIME()
            ]);

        return $update;
    }

    public function delete()
    {
        $del = DB::table('comentario')->where('comentario.id_comentario', '=', $this->getIdComentario())->delete();

        return $del;
    }

    public function show()
    {
        $row = DB::table('comentario')->select('comentario.*')->where('comentario.id_comentario', '=', $this->getIdComentario())->first();

        if ($row) {
            return (object)$row;
        } else {
            return null;
        }
    }

}
