<?php

namespace App\Http\Dao\Implement;

use App\Http\Dao\Interfaces\DAORuta;
use App\Http\Dto\DTORuta;
use Illuminate\Support\Facades\DB;

class IDAORuta extends DTORuta implements DAORuta
{

    public function all()
    {
        $result = DB::table('ruta')
            ->select('ruta.*',
                'zona.id_zona',
                'zona.zona',
                'orientacion.orientacion')
            ->leftJoin('zona', 'zona.id_zona', '=', 'ruta.id_zona')
            ->leftJoin('orientacion', 'orientacion.id_orientacion', '=', 'zona.id_orientacion')
            ->get();

        return $result;
    }

    public function create()
    {
        $inset = DB::table('ruta')
            ->insertGetId([
                "id_zona" => $this->getIdZona(),
                "ruta" => $this->getRuta(),
                "activo" => $this->getActivo(),
                "created_at" => $this->DATETIME(),
                "updated_at" => $this->DATETIME()
            ]);

        return $inset;
    }

    public function update()
    {
        $update = DB::table('ruta')
            ->where('ruta.id_ruta', '=', $this->getIdRuta())
            ->update([
                "id_zona" => $this->getIdZona(),
                "ruta" => $this->getRuta(),
                "activo" => $this->getActivo(),
                "updated_at" => $this->DATETIME()
            ]);

        return $update;
    }

    public function delete()
    {
        $del = DB::table('ruta')->where('ruta.id_ruta', '=', $this->getIdRuta())->delete();

        return $del;
    }

    public function show()
    {
        $row = DB::table('ruta')->select('ruta.*')->where('ruta.id_ruta', '=', $this->getIdRuta())->first();

        if ($row) {
            return (object)$row;
        } else {
            return null;
        }
    }

}
