<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group(['middleware' => 'cors'], function () {

    Route::get('_BackUp', 'SIS\BackUpDataBaseController@backup');

    Route::get('_Auth', 'CAT\TestController@Test');
    Route::post('_Auth', 'CAT\TestController@Test');
    Route::post('_Cat_MySql_Log', 'CAT\TestController@cat_mysql_log');

    Route::get('_Base64', 'CAT\TestController@base64');

    Route::get('_Test', 'CAT\TestController@get_test');
    Route::post('_Test', 'CAT\TestController@post_test');

    Route::get('_Mail', 'CAT\TestController@sendEmailReminder');
    Route::get('_Mail/{email}', 'CAT\TestController@sendEmailReminder');
    Route::get('_Mail/{email}/{name}', 'CAT\TestController@sendEmailReminder');

    Route::get('_Pusher', 'SIS\PusherController@sendPush');
    Route::post('_Pusher', 'SIS\PusherController@sendPush');

    Route::get('_Clear_Ficha_Tecnica', 'CAT\TruncateController@ClearFichaTecnica');


    /*
  * Api Auth
  * ----------------------------------------------------------------------------------------------------------------
  * */

    Route::post('_Auth_User_LogIn', 'Auth\LogInController@UserLogIn');
    Route::post('_Auth_Verify_User_Token', 'Auth\UserController@VerifyUserToken');
    Route::post('_Auth_User_Verify_New', 'Auth\UserController@VerifyUserNew');
    Route::post('_Auth_User_Verify_Id', 'Auth\UserController@VerifyUserId');
    Route::post('_Auth_User_Change_Password', 'Auth\UserController@UserChangePassword');
    Route::post('_Auth_User_Change_Time_Token', 'Auth\UserController@UserChangeTimeToken');
    Route::post('_Auth_User_New', 'Auth\UserController@UserNew');
    Route::post('_Auth_User_List', 'Auth\UserController@UserList');
    Route::post('_Auth_Cat_List', 'Auth\UserController@CatList');
    Route::post('_Send_Email', 'Auth\SendMailController@SendEmail');


    /*
     * Exportar pdf
     * ----------------------------------------------------------------------------------------------------------------
     * */

    Route::get('pdfexcel', 'EXPORT\DemoExportPDFController@pdfexcel');
    Route::get('texid/{key}', 'EXPORT\ExportarExpedienteController@expedientexid');

    /*
     * Webservices catalogos GET
     * ----------------------------------------------------------------------------------------------------------------
     * */

    Route::get('cat/config', 'CAT\CatController@cat_config');
    Route::get('cat/sexo', 'CAT\CatController@cat_sexo');
    Route::get('cat/tipo_usuario', 'CAT\CatController@cat_tipo_usuario');
    Route::get('cat/estado', 'CAT\CatController@cat_estado');
    Route::get('cat/municipio', 'CAT\CatController@cat_municipio');
    Route::get('cat/municipio/{id_estado}', 'CAT\CatController@cat_municipio');
    Route::get('cat/modalidad', 'CAT\CatController@cat_modalidad');
    Route::get('cat/tipo_inscripcion', 'CAT\CatController@cat_tipo_inscripcion');
    Route::get('cat/horario', 'CAT\CatController@cat_horario');
    Route::get('cat/nivel', 'CAT\CatController@cat_nivel');
    Route::get('cat/instructor', 'CAT\CatController@cat_instructor');

    /*
     * Webservices generales
     * ----------------------------------------------------------------------------------------------------------------
     * */

    Route::post('_Iniciar_Session', 'SIS\IniciarSesionController@IniciarSesion');
    Route::post('_Verificar_Token_Access', 'SIS\IniciarSesionController@VerificarTokenAccess');

    Route::post('_Enviar_Codigo_Recuperacion', 'SIS\IniciarSesionController@EnviarCodigoRecuperacion');
    Route::post('_Verificar_Codigo_Recuperacion', 'SIS\IniciarSesionController@VerificarCodigoRecuperacion');
    Route::post('_Cambiar_Password', 'SIS\IniciarSesionController@CambiarPassword');

    Route::post('_Usuario_Registro_Verificar', 'SIS\UsuarioRegistroController@UsuarioRegistroVerificar');
    Route::post('_Usuario_Registro_Guardar', 'SIS\UsuarioRegistroController@UsuarioRegistroGuardar');

    Route::post('_Usuarios_Datos', 'SIS\UsuariosController@listar_usuarios');
    Route::post('_Usuarios_Guardar', 'SIS\UsuariosController@agregar_usuarios');
    Route::post('_Usuarios_Modificar', 'SIS\UsuariosController@modificar_usuarios');
    Route::post('_Usuarios_Eliminar', 'SIS\UsuariosController@eliminar_usuarios');
    Route::post('_Usuarios_Tipo', 'SIS\UsuariosController@tipo_usuarios');

    Route::post('_Menus_Datos', 'SIS\MenuSubMenuController@listar_menus');

    Route::post('_Menus_Guardar', 'SIS\MenuSubMenuController@agregar_menus');
    Route::post('_Menus_Modificar', 'SIS\MenuSubMenuController@modificar_menus');
    Route::post('_Menus_Eliminar', 'SIS\MenuSubMenuController@eliminar_menus');
    Route::post('_Menus_Status', 'SIS\MenuSubMenuController@status_menus');

    Route::post('_Sub_Menus_Guardar', 'SIS\MenuSubMenuController@agregar_sub_menus');
    Route::post('_Sub_Menus_Modificar', 'SIS\MenuSubMenuController@modificar_sub_menus');
    Route::post('_Sub_Menus_Eliminar', 'SIS\MenuSubMenuController@eliminar_sub_menus');
    Route::post('_Sub_Menus_Status', 'SIS\MenuSubMenuController@status_sub_menus');

    Route::post('_Roles_Permisos/_Menus_Sub_Menu_Datos', 'SIS\RolesPermisosController@lista_menu_sub_menu');
    Route::post('_Roles_Permisos/_Menus_Acceso_Menu', 'SIS\RolesPermisosController@menu_acceso_menu');
    Route::post('_Roles_Permisos/_Menus_Acceso_Sub_Menu', 'SIS\RolesPermisosController@menu_acceso_sub_menu');

    Route::post('_Perfil_Usuarios_Datos', 'SIS\PerfilController@perfil_usuarios_datos');
    Route::post('_Perfil_Usuarios_Solicitar_Cambiar_Contrasena', 'SIS\PerfilController@perfil_usuarios_solicitar_cambio_contrasena');
    Route::post('_Perfil_Usuarios_Cambiar_Contrasena', 'SIS\PerfilController@perfil_usuarios_cambiar_contrasena');
    Route::post('_Perfil_Usuarios_Cambiar_Foto', 'SIS\PerfilController@perfil_usuarios_cambiar_foto');
    Route::post('_Perfil_Usuarios_Cambiar_Portada', 'SIS\PerfilController@perfil_usuarios_cambiar_portada');
    Route::post('_Perfil_Usuarios_Actualizar_Informacion', 'SIS\PerfilController@perfil_usuarios_actualizar_informacion');
    Route::post('_Perfil_Usuarios_Actualizar_Correos_Telefonos', 'SIS\PerfilController@perfil_usuarios_actualizar_correos_telefonos');
    Route::post('_Perfil_Usuarios_Actualizar_Domicilio', 'SIS\PerfilController@perfil_usuarios_actualizar_domicilio');
    Route::post('_Perfil_Usuarios_Player_Id_Guardar', 'SIS\PerfilController@perfil_usuarios_player_id_guardar');
    Route::post('_Perfil_Usuarios_Player_Id_Prueba', 'SIS\PerfilController@perfil_usuarios_player_id_prueba');

    Route::post('_Configuracion_Cambiar_Tiempo_Expira_Token', 'SIS\ConfiguracionController@cambiar_tiempo_expira_token');
    Route::post('_Configuracion_Cambiar_Tiempo_Toast', 'SIS\ConfiguracionController@cambiar_tiempo_toast');
    Route::post('_Configuracion_Cambiar_Tipo_Menu', 'SIS\ConfiguracionController@cambiar_tipo_menu');

    /*
     * Webservices del sistema
     * ----------------------------------------------------------------------------------------------------------------
     * */

    Route::post('_Cat/_Tipo_Usuario_Datos', 'CAT\TipoUsuarioController@listar_tipo_usuario');
    Route::post('_Cat/_Tipo_Usuario_Guardar', 'CAT\TipoUsuarioController@agregar_tipo_usuario');
    Route::post('_Cat/_Tipo_Usuario_Modificar', 'CAT\TipoUsuarioController@modificar_tipo_usuario');
    Route::post('_Cat/_Tipo_Usuario_Eliminar', 'CAT\TipoUsuarioController@eliminar_tipo_usuario');

    Route::post('_Cat/_Sexo_Datos', 'CAT\CATSexoController@listar_sexo');
    Route::post('_Cat/_Sexo_Guardar', 'CAT\CATSexoController@agregar_sexo');
    Route::post('_Cat/_Sexo_Modificar', 'CAT\CATSexoController@modificar_sexo');
    Route::post('_Cat/_Sexo_Eliminar', 'CAT\CATSexoController@eliminar_sexo');

    Route::post('_Recibos_Datos', 'SIS\RecibosController@listar_recibos');
    Route::post('_Recibos_Guardar', 'SIS\RecibosController@agregar_recibos');
    Route::post('_Recibos_Modificar', 'SIS\RecibosController@modificar_recibos');
    Route::post('_Recibos_Eliminar', 'SIS\RecibosController@eliminar_recibos');
    Route::post('_Recibos_Descargar', 'SIS\RecibosController@descargar_zip_recibos');



});
